//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.42
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

using Microsoft.Ccr.Core;
using Microsoft.Dss.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Xml;
using MultipleInstanceSimulation = RoboRealm.MultipleInstanceSimulation;
using realm = RoboRealm.Proxy;
using System.Drawing;
using System.Net;
using System.Drawing.Imaging;
using submgr = Microsoft.Dss.Services.SubscriptionManager;
using W3C.Soap;
using System.IO;

#region Simulation namespaces
using Microsoft.Robotics.Simulation;
using Microsoft.Robotics.Simulation.Engine;
using engineproxy = Microsoft.Robotics.Simulation.Engine.Proxy;
using Microsoft.Robotics.Simulation.Physics;

using drive = Microsoft.Robotics.Services.Simulation.Drive.Proxy;
using simcam = Microsoft.Robotics.Services.Simulation.Sensors.SimulatedWebcam.Proxy;
using simengine = Microsoft.Robotics.Simulation.Engine;
using webcam = Microsoft.Robotics.Services.WebCam;

using Microsoft.Robotics.PhysicalModel;
using Microsoft.Dss.Core.DsspHttp;
#endregion

namespace RoboRealm.MultipleInstanceSimulation
{
    /// <summary>
    /// Implementation class for MultipleInstanceSimulation
    /// </summary>
    [DisplayName("MultipleInstanceSimulation")]
    [Description("The MultipleInstanceSimulation Service")]
    [Contract(Contract.Identifier)]
    public class MultipleInstanceSimulationService : DsspServiceBase
    {
        [Partner("realm1", Contract = realm.Contract.Identifier, CreationPolicy = PartnerCreationPolicy.CreateAlways)]
        private realm.InterfaceOperations _realmPort1 = new realm.InterfaceOperations();
        private realm.InterfaceOperations _realmNotify1 = new realm.InterfaceOperations();

        [Partner("realm2", Contract = realm.Contract.Identifier, CreationPolicy = PartnerCreationPolicy.CreateAlways)]
        private realm.InterfaceOperations _realmPort2 = new realm.InterfaceOperations();
        private realm.InterfaceOperations _realmNotify2 = new realm.InterfaceOperations();

        [Partner("Engine", Contract = engineproxy.Contract.Identifier, CreationPolicy = PartnerCreationPolicy.UseExistingOrCreate)]
        private engineproxy.SimulationEnginePort _engineServicePort = new engineproxy.SimulationEnginePort();

        [Partner("SubMgr", Contract = submgr.Contract.Identifier, CreationPolicy = PartnerCreationPolicy.CreateAlways)]
        submgr.SubscriptionManagerPort _subMgrPort = new submgr.SubscriptionManagerPort();

        simengine.SimulationEnginePort _notificationTarget;
        simengine.CameraEntity _entity1;
        simengine.CameraEntity _entity2;

        LegoNXTTribot robotBaseEntity1 = null;
        LegoNXTTribot robotBaseEntity2 = null;

        /// <summary>
        /// _state
        /// </summary>
        private webcam.WebCamState _state = new webcam.WebCamState();
        /// <summary>
        /// _main Port
        /// </summary>
        [ServicePort("/MultipleInstanceSimulation", AllowMultipleInstances = false)]
        private webcam.WebCamOperations _mainPort = new webcam.WebCamOperations();
        /// <summary>
        /// Default Service Constructor
        /// </summary>
        public MultipleInstanceSimulationService(DsspServiceCreationPort creationPort) :
            base(creationPort)
        {
        }
        /// <summary>
        /// Service Start
        /// </summary>
        protected override void Start()
        {
            base.Start();

            _notificationTarget = new simengine.SimulationEnginePort();

            // issue Subscribe
            simengine.SimulationEngine.GlobalInstancePort.Subscribe(ServiceInfo.PartnerList, _notificationTarget);

            // Add service specific initialization here.
            realm.SetCaptureRequest req1 = new realm.SetCaptureRequest();
            req1.captureImage = false;
            req1.captureVariable = true;
            req1.Hostname = "localhost";
            req1.Port = 6060;
            _realmPort1.SetCapture(req1);

            _realmPort1.Subscribe(_realmNotify1);

            // Add another RoboRealm instance
            realm.SetCaptureRequest req2 = new realm.SetCaptureRequest();
            req2.captureImage = false;
            req2.captureVariable = true;
            req2.Hostname = "localhost";
            req2.Port = 6061;
            _realmPort2.SetCapture(req2);

            _realmPort2.Subscribe(_realmNotify2);

            SetupCamera();

            PopulateWorld();

            Activate(Arbiter.Receive(false, TimeoutPort(100), CheckForUpdate));
        }

        // Send an update message to ourself at an interval specified by the camera entity.
        // If the interval is 0, check once per second to see if the interval has changed but
        // don't do an update.
        void CheckForUpdate(DateTime time)
        {
            if (_entity1 == null)
                return; // the entity went away, do no more updates

            if (_entity1.UpdateInterval != 0)
            {
                _mainPort.Post(new webcam.UpdateFrame());
                Activate(Arbiter.Receive(false, TimeoutPort(_entity1.UpdateInterval), CheckForUpdate));
            }
            else
                Activate(Arbiter.Receive(false, TimeoutPort(1000), CheckForUpdate));
        }

        void DeleteEntityNotificationHandler(simengine.DeleteSimulationEntity del)
        {
            _entity1 = null;
            _entity2 = null;
        }

        [ServiceHandler(ServiceHandlerBehavior.Teardown)]
        public IEnumerator<ITask> DropHandler(DsspDefaultDrop drop)
        {
            DefaultDropHandler(drop);
            yield break;
        }

        private void SetupCamera()
        {
            // Set up initial view
            CameraView view = new CameraView();
            view.EyePosition = new Vector3(2.491269f, 0.598689f, 1.046625f);
            view.LookAtPoint = new Vector3(1.873792f, 0.40983f, 0.2830455f);
            SimulationEngine.GlobalInstancePort.Update(view);
        }

        private void PopulateWorld()
        {
            AddSky();
            AddGround();
            AddConvexMesh("street_cone.obj", new Vector3(0.7f, 1f, -2.5f));
            // create Camera Entity ans start SimulatedWebcam service
            _entity1 = CreateCamera(1);
            robotBaseEntity1 = AddLegoNxtRobot(new Vector3(2, 0.1f, 0), _entity1, 1);
            _entity2 = CreateCamera(2);
            robotBaseEntity2 = AddLegoNxtRobot(new Vector3(1, 0.1f, 0), _entity2, 2);
            //SimulationEngine.GlobalInstancePort.Insert(_entity1);
            //SimulationEngine.GlobalInstancePort.Insert(_entity2);
        }

        #region Environment Entities

        void AddSky()
        {
            // Add a sky using a static texture. We will use the sky texture
            // to do per pixel lighting on each simulation visual entity
            SkyEntity sky = new SkyEntity("sky.dds", "sky_diff.dds");
            SimulationEngine.GlobalInstancePort.Insert(sky);

            // Add a directional light to simulate the sun.
            LightSourceEntity sun = new LightSourceEntity();
            sun.State.Name = "Sun";
            sun.Type = LightSourceEntityType.Directional;
            sun.Color = new Vector4(0.8f, 0.8f, 0.8f, 1);
            sun.Direction = new Vector3(-1.0f, -1.0f, 0.5f);
            SimulationEngine.GlobalInstancePort.Insert(sun);
        }

        void AddGround()
        {
            HeightFieldShapeProperties hf = new HeightFieldShapeProperties("height field",
                64, // number of rows 
                100, // distance in meters, between rows
                64, // number of columns
                100, // distance in meters, between columns
                1, // scale factor to multiple height values 
                -1000); // vertical extent of the height field. Should be set to large negative values

            // create array with height samples
            hf.HeightSamples = new HeightFieldSample[hf.RowCount * hf.ColumnCount];
            for (int i = 0; i < hf.RowCount * hf.ColumnCount; i++)
            {
                hf.HeightSamples[i] = new HeightFieldSample();
                hf.HeightSamples[i].Height = (short)(Math.Sin(i * 0.01));
            }

            // create a material for the entire field. We could also specify material per sample.
            hf.Material = new MaterialProperties("ground", 0.8f, 0.5f, 0.8f);

            // insert ground entity in simulation and specify a texture
            SimulationEngine.GlobalInstancePort.Insert(new HeightFieldEntity(hf, "03RamieSc.dds"));
            /*
                        // For a more interesting ground uncomment this next block and comment out the code before this.
                        TerrainEntity ground = new TerrainEntity(
                                         "terrain.bmp",
                                         "terrain_tex.jpg",
                                         new MaterialProperties("ground",
                                             0.2f, // restitution
                                             0.5f, // dynamic friction
                                             0.5f) // static friction
                                         );
                        SimulationEngine.GlobalInstancePort.Insert(ground);
                        */
        }

        private void AddConvexMesh(string name, Vector3 pos)
        {
            Shape cshape = null;
            SimplifiedConvexMeshEnvironmentEntity centity = new SimplifiedConvexMeshEnvironmentEntity(pos,
                                                                        name,
                                                                        cshape);
            centity.State.MassDensity.Mass = 30;
            centity.State.Name = "Convex mesh:" + name + ":" + Guid.NewGuid().ToString();
            SimulationEngine.GlobalInstancePort.Insert(centity);
        }

        #endregion

        #region Robot Entities

        private CameraEntity CreateCamera(int num)
        {
            // low resolution, wide Field of View
            CameraEntity cam = new CameraEntity(320, 240);
            cam.State.Name = "robocam"+num;
            // just on top of the bot
            cam.State.Pose.Position = new Vector3(0.0f, 0.5f, 0.0f);
            // camera renders in an offline buffer at each frame
            // required for service
            cam.IsRealTimeCamera = true;
            cam.UpdateInterval = 200;

            // Start simulated webcam service
            simcam.Contract.CreateService(
                ConstructorPort,
                Microsoft.Robotics.Simulation.Partners.CreateEntityPartner(
                    "http://localhost/" + cam.State.Name)
            );

            return cam;
        }

        #endregion

        #region Lego NXT
        LegoNXTTribot AddLegoNxtRobot(Vector3 position, CameraEntity cam, int id)
        {
            LegoNXTTribot robotBaseEntity = CreateLegoNxtMotorBase(ref position, id);

            // insert as child of motor base
            robotBaseEntity.InsertEntity(cam);

            // Finaly insert the motor base and its two children 
            // to the simulation
            SimulationEngine.GlobalInstancePort.Insert(robotBaseEntity);

            robotBaseEntity.SetMotorTorque((float)0.15, (float)0.0);

            return robotBaseEntity;
        }

        private LegoNXTTribot CreateLegoNxtMotorBase(ref Vector3 position, int id)
        {
            // use supplied entity that creates a motor base 
            // with 2 active wheels and one caster
            LegoNXTTribot robotBaseEntity = new LegoNXTTribot(position);

            // specify mesh. 
            robotBaseEntity.State.Assets.Mesh = "LegoNXTTribot.bos";

            // the name below must match manifest
            robotBaseEntity.State.Name = "LegoNXTMotorBase_"+id;

            // Start simulated arcos motor service
            CreateService(
                drive.Contract.Identifier,
                Microsoft.Robotics.Simulation.Partners.CreateEntityPartner(
                    "http://localhost/" + robotBaseEntity.State.Name)
            );
            return robotBaseEntity;
        }

        #endregion

        #region DSSP Handlers
        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public IEnumerator<ITask> HttpGetHandler(HttpGet get)
        {
            get.ResponsePort.Post(new HttpResponseType(HttpStatusCode.OK, _state));
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public IEnumerator<ITask> ReplaceHandler(Replace replace)
        {
            replace.ResponsePort.Post(new DefaultReplaceResponseType());
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public IEnumerator<ITask> UpdateFrameHandler(webcam.UpdateFrame update)
        {
            if (_entity1 != null)
            {
                PortSet<int[], Exception> result = new PortSet<int[], Exception>();
                _entity1.CaptureScene(result);

                yield return Arbiter.Choice(result,
                    delegate(int[] pixels)
                    {
                        BitmapData raw = null;
                        Bitmap b = _entity1.CreateBitmapFromArray(pixels);

                        if (b != null)
                        {
                            Size size = b.Size;

                            try
                            {
                                raw = b.LockBits(new Rectangle(Point.Empty, size), ImageLockMode.ReadOnly, PixelFormat.Format24bppRgb);
                                realm.SetFrameRequest newFrame = new realm.SetFrameRequest();
                                int byteLen = size.Width * size.Height * 3;
                                newFrame.pixels = new byte[byteLen];
                                newFrame.Size = new Size(size.Width, size.Height);
                                System.Runtime.InteropServices.Marshal.Copy(raw.Scan0, newFrame.pixels, 0, byteLen);

                                _realmPort1.SetFrame(newFrame);

                                SpawnIterator(GetVariable1);
                            }
                            catch (Exception)
                            {
                            }
                            finally
                            {
                                if (raw != null)
                                {
                                    b.UnlockBits(raw);
                                }
                            }
                        }
                        //frame.Save("C:\\temp\\test.jpg");
                    },
                    delegate(Exception ex)
                    {
                        update.ResponsePort.Post(Fault.FromException(ex));
                    });
            }
            
            if (_entity2 != null)
            {
                PortSet<int [], Exception> result = new PortSet<int[], Exception>();
                _entity2.CaptureScene(result);

                yield return Arbiter.Choice(result,
                    delegate(int []pixels)
                    {
                        BitmapData raw = null;
                        Bitmap b = _entity1.CreateBitmapFromArray(pixels);

                        if (b != null)
                        {
                            Size size = b.Size;

                            try
                            {
                                raw = b.LockBits(new Rectangle(Point.Empty, size), ImageLockMode.ReadOnly, PixelFormat.Format24bppRgb);
                                realm.SetFrameRequest newFrame = new realm.SetFrameRequest();
                                int byteLen = size.Width * size.Height * 3;
                                newFrame.pixels = new byte[byteLen];
                                newFrame.Size = new Size(size.Width, size.Height);
                                System.Runtime.InteropServices.Marshal.Copy(raw.Scan0, newFrame.pixels, 0, byteLen);

                                _realmPort2.SetFrame(newFrame);

                                SpawnIterator(GetVariable2);
                            }
                            catch (Exception)
                            {
                            }
                            finally
                            {
                                if (raw != null)
                                {
                                    b.UnlockBits(raw);
                                }
                            }
                        }
                        //frame.Save("C:\\temp\\test.jpg");
                    },
                    delegate(Exception ex)
                    {
                        update.ResponsePort.Post(Fault.FromException(ex));
                    });
            }
        }

        public IEnumerator<ITask> GetVariable1()
        {
            realm.QueryVariablesRequest req = new realm.QueryVariablesRequest();
            req._names = new List<String>();
            req._names.Add("LEFT_MOTOR");
            req._names.Add("RIGHT_MOTOR");
            if (req != null)
            {
                yield return Arbiter.Choice(
                    _realmPort1.QueryVariables(req),
                    delegate(realm.QueryVariablesResponse res)
                    {
                        if ((res._values[0] != null) && (res._values[1] != null))
                        {
                            float leftWheelPower = (float)(Convert.ToInt32(res._values[0]) - 128.0f) / 128.0f;
                            float rightWheelPower = (float)(Convert.ToInt32(res._values[1]) - 128.0f) / 128.0f;
                            robotBaseEntity1.SetMotorTorque((float)leftWheelPower, (float)rightWheelPower);
                        }
                    },
                    delegate(Fault f)
                    {
                        LogError(LogGroups.Console, "Could not query webcam frame", f);
                    });
            }
        }

        public IEnumerator<ITask> GetVariable2()
        {
            realm.QueryVariablesRequest req = new realm.QueryVariablesRequest();
            req._names = new List<String>();
            req._names.Add("LEFT_MOTOR");
            req._names.Add("RIGHT_MOTOR");
            if (req != null)
            {
                yield return Arbiter.Choice(
                    _realmPort2.QueryVariables(req),
                    delegate(realm.QueryVariablesResponse res)
                    {
                        if ((res._values[0] != null) && (res._values[1] != null))
                        {
                            float leftWheelPower = (float)(Convert.ToInt32(res._values[0]) - 128.0f) / 128.0f;
                            float rightWheelPower = (float)(Convert.ToInt32(res._values[1]) - 128.0f) / 128.0f;
                            robotBaseEntity2.SetMotorTorque((float)leftWheelPower, (float)rightWheelPower);
                        }
                    },
                    delegate(Fault f)
                    {
                        LogError(LogGroups.Console, "Could not query webcam frame", f);
                    });
            }
        }

        #endregion
    }
}
