//------------------------------------------------------------------------------
// Interface.cs
//
//     This code was generated by the DssNewService tool.
//
//------------------------------------------------------------------------------
using Microsoft.Ccr.Core;
using Microsoft.Dss.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Xml;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Net;
using System.Net.Mime;
using Microsoft.Dss.Core.DsspHttpUtilities;
using submgr = Microsoft.Dss.Services.SubscriptionManager;
using Microsoft.Dss.Core.DsspHttp;
using System.Collections.Specialized;
using W3C.Soap; // Fault

namespace RoboRealm
{
    /// <summary>
    /// The Interface Service
    /// </summary>
    [DisplayName("RoboRealm Interface")]
    [Description("The RoboRealm Interface Service")]
    [Contract(Contract.Identifier)]
    public class InterfaceService : DsspServiceBase
    {
        [EmbeddedResource("RoboRealm.interface.xslt")]
        string _transform = null;
        
        DsspHttpUtilitiesPort _utilitiesPort = new DsspHttpUtilitiesPort();

        /// <summary>
        /// _state
        /// </summary>
        private InterfaceState _state = new InterfaceState();

        FramePort _framePort = new FramePort();
        FrameGrabber _frameGrabber = new FrameGrabber("localhost", 6060);

        [Partner("SubMgr", Contract = submgr.Contract.Identifier, CreationPolicy = PartnerCreationPolicy.CreateAlways)]
        submgr.SubscriptionManagerPort _submgrPort = new submgr.SubscriptionManagerPort();

        /// <summary>
        /// _main Port
        /// </summary>
        [ServicePort("/roborealm", AllowMultipleInstances = true)]
        private InterfaceOperations _mainPort = new InterfaceOperations();
        private InterfaceOperations _fwdPort;
        /// <summary>
        /// Default Service Constructor
        /// </summary>
        public InterfaceService(DsspServiceCreationPort creationPort)
            :
                base(creationPort)
        {
        }
        /// <summary>
        /// Service Start
        /// </summary>
        protected override void Start()
        {
            Activate(
                Arbiter.Interleave(
                    new TeardownReceiverGroup(
                        Arbiter.Receive<DsspDefaultDrop>(false, _mainPort, DropHandler)
                    ),
                    new ExclusiveReceiverGroup
                    (
                        Arbiter.ReceiveWithIterator<SetConnectionProperties>(true, _mainPort, SetConnectionPropertiesHandler),
                        Arbiter.ReceiveWithIterator<SetCapture>(true, _mainPort, SetCaptureHandler),
                        Arbiter.ReceiveWithIterator<QueryVariable>(true, _mainPort, QueryVariableHandler),
                        Arbiter.ReceiveWithIterator<LoadProgram>(true, _mainPort, LoadProgramHandler),
                        Arbiter.ReceiveWithIterator<ExecuteProgram>(true, _mainPort, ExecuteProgramHandler),
                        Arbiter.ReceiveWithIterator<QueryVariables>(true, _mainPort, QueryVariablesHandler),
                        Arbiter.ReceiveWithIterator<HttpPost>(true, _mainPort, HttpPostHandler),
                        Arbiter.ReceiveWithIterator<QueryFrame>(true, _mainPort, QueryFrameHandler),
                        Arbiter.ReceiveWithIterator<UpdateFrame>(true, _mainPort, UpdateFrameHandler),
                        Arbiter.ReceiveWithIterator<SetFrame>(true, _mainPort, SetFrameHandler),
                        Arbiter.ReceiveWithIterator<SetVariable>(true, _mainPort, SetVariableHandler),
                        Arbiter.Receive(true, _framePort, FrameHandler)
                    ),
                    new ConcurrentReceiverGroup
                    (
                        Arbiter.ReceiveWithIterator<HttpGet>(true, _mainPort, HttpGetHandler),
                        Arbiter.ReceiveWithIterator<Get>(true, _mainPort, GetHandler),
                        Arbiter.ReceiveWithIterator<HttpQuery>(true, _mainPort, HttpQueryHandler),
                        Arbiter.ReceiveWithIterator<Subscribe>(true, _mainPort, SubscribeHandler),
                        Arbiter.Receive<DsspDefaultLookup>(true, _mainPort, DefaultLookupHandler)
                    ))
            );

            _utilitiesPort = DsspHttpUtilitiesService.Create(Environment);

            // Insert ourselves into the directory so that others can find us
            DirectoryInsert();

            _fwdPort = ServiceForwarder<InterfaceOperations>(ServiceInfo.Service);

            _frameGrabber.CaptureFrame += OnCaptureFrame;

            _frameGrabber.SetCapture(true, true);
            _frameGrabber.SetConnectionProperties("localhost", 6060);
            _frameGrabber.StartCapture();
        }
        /// <summary>
        /// Get Handler
        /// </summary>
        /// <param name="get"></param>
        /// <returns></returns>
        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> GetHandler(Get get)
        {
            get.ResponsePort.Post(_state);
            yield break;
        }

        void DropHandler(DsspDefaultDrop drop)
        {
            base.DefaultDropHandler(drop);
        }

        IEnumerator<ITask> HttpQueryHandler(HttpQuery query)
        {
            return HttpHandler(query.Body.Context, query.ResponsePort);
        }

        IEnumerator<ITask> HttpGetHandler(HttpGet get)
        {
            return HttpHandler(get.Body.Context, get.ResponsePort);
        }

        IEnumerator<ITask> HttpHandler(HttpListenerContext context, PortSet<HttpResponseType, Fault> responsePort)
        {
            HttpListenerRequest request = context.Request;
            HttpListenerResponse response = context.Response;

            string path = request.Url.AbsolutePath.ToLowerInvariant();
            int lastSlash = path.LastIndexOf('/');
            if (lastSlash>0)
            {
                path = path.Substring(lastSlash);
            }

            string type;
            ImageFormat format;

            switch (path)
            {
                case "/jpeg":
                case "/jpg":
                    type = MediaTypeNames.Image.Jpeg;
                    format = ImageFormat.Jpeg;
                    break;
                case "/bmp":
                    type = "image/bmp";
                    format = ImageFormat.Bmp;
                    break;
                case "/png":
                    type = "image/png";
                    format = ImageFormat.Png;
                    break;
                case "/tif":
                case "/tiff":
                    type = "image/tiff";
                    format = ImageFormat.Tiff;
                    break;
                case "/gif":
                    type = MediaTypeNames.Image.Gif;
                    format = ImageFormat.Gif;
                    break;
                default:
                    responsePort.Post(new HttpResponseType(HttpStatusCode.OK, _state, _transform));
                    yield break;
            }

            if (_state.Image == null)
            {
                responsePort.Post(new HttpResponseType(HttpStatusCode.NotFound, _state, _transform));
                yield break;
            }

            // check the the API connection is running
            _frameGrabber.CheckCapture();

            Image curImage = _state.Image;

            using (MemoryStream stream = new MemoryStream())
            {
                curImage.Save(stream, format);
                stream.Position = 0;

                response.AddHeader("Cache-Control", "No-cache");

                WriteResponseFromStream write = new WriteResponseFromStream(
                    context, stream, type
                );

                _utilitiesPort.Post(write);

                yield return Arbiter.Choice(
                    write.ResultPort,
                    delegate(Stream res)
                    {
                        stream.Close();
                    },
                    delegate(Exception e)
                    {
                        stream.Close();
                        LogError(e);
                    }
                );
            }
        }

        IEnumerator<ITask> LoadProgramHandler(LoadProgram info)
        {
            String filename = info.Body.Filename;
            if (filename != null)
            {
                LoadProgramResponse response = new LoadProgramResponse();

                if (_frameGrabber.LoadProgram(filename))
                    response.Error = "";
                else
                    response.Error = "Program not loaded";

                info.ResponsePort.Post(response);
            }
            else
            {
                info.ResponsePort.Post(new LoadProgramResponse());
            }

            yield break;
        }

        IEnumerator<ITask> SetConnectionPropertiesHandler(SetConnectionProperties info)
        {
            _frameGrabber.SetConnectionProperties(info.Body.Hostname, info.Body.Port);

            yield break;
        }

        IEnumerator<ITask> ExecuteProgramHandler(ExecuteProgram info)
        {
            string source = info.Body.Source;
            if (source != null)
            {
                ExecuteProgramResponse response = new ExecuteProgramResponse();

                _frameGrabber.Execute(source);

                info.ResponsePort.Post(response);
            }
            else
            {
                info.ResponsePort.Post(new ExecuteProgramResponse());
            }

            yield break;
        }

        IEnumerator<ITask> QueryVariableHandler(QueryVariable query)
        {
            String name = query.Body.Name;
            if (name != null)
            {
                QueryVariableResponse response = new QueryVariableResponse();

                response.Name = name;
                response.Value = _frameGrabber.QueryVariable(name);

                query.ResponsePort.Post(response);
            }
            else
            {
                query.ResponsePort.Post(new QueryVariableResponse());
            }

            yield break;
        }

        IEnumerator<ITask> QueryVariablesHandler(QueryVariables query)
        {
            QueryVariablesRequest names = query.Body;
            if (names != null)
            {
                QueryVariablesResponse response = new QueryVariablesResponse();

                int i;
                for (i = 0; i < names.Count(); i++)
                {
                    response._values.Add(_frameGrabber.QueryVariable(names.ItemAt(i)));
                }

                query.ResponsePort.Post(response);
            }
            else
            {
                query.ResponsePort.Post(new QueryVariablesResponse());
            }

            yield break;
        }

        IEnumerator<ITask> QueryFrameHandler(QueryFrame query)
        {
            if (_state.Image == null)
            {
                query.ResponsePort.Post(new QueryFrameResponse());
                yield break;
            }

            if (query.Body.Format == Guid.Empty)
            {
                // raw image requested;
                BitmapData raw = null;
                try
                {
                    raw = _state.Image.LockBits(new Rectangle(Point.Empty, _state.Size),
                        ImageLockMode.ReadOnly, PixelFormat.Format24bppRgb);

                    int size = raw.Height * raw.Stride;

                    QueryFrameResponse response = new QueryFrameResponse();

                    response.TimeStamp = _state.TimeStamp;
                    response.Frame = new byte[size];
                    response.Size = new Size(raw.Width, raw.Height);
                    response.Format = Guid.Empty;

                    System.Runtime.InteropServices.Marshal.Copy(raw.Scan0, response.Frame, 0, size);

                    query.ResponsePort.Post(response);
                }
                finally
                {
                    if (raw != null)
                    {
                        _state.Image.UnlockBits(raw);
                    }
                }
            }
            else
            {
                ImageFormat format = new ImageFormat(query.Body.Format);

                using (MemoryStream stream = new MemoryStream())
                {
                    Size size = query.Body.Size;
                    if (size == _state.Image.Size ||
                        size.Width == 0 ||
                        size.Height == 0 ||
                        size.Width >= _state.Image.Width ||
                        size.Height >= _state.Image.Height)
                    {
                        size = _state.Image.Size;
                        _state.Image.Save(stream, format);
                    }
                    else
                    {
                        using (Bitmap temp = new Bitmap(
                            _state.Image, query.Body.Size))
                        {
                            temp.Save(stream, format);
                        }
                    }


                    QueryFrameResponse response = new QueryFrameResponse();
                    response.TimeStamp = _state.TimeStamp;
                    response.Frame = new byte[(int)stream.Length];
                    response.Size = size;
                    response.Format = format.Guid;

                    stream.Position = 0;
                    stream.Read(response.Frame, 0, response.Frame.Length);

                    query.ResponsePort.Post(response);
                }
            }
            yield break;
        }

        IEnumerator<ITask> SetVariableHandler(SetVariable update)
        {
            SetVariableInternal(update);
            yield break;
        }

        void SetVariableInternal(SetVariable update)
        {
            _state.Variables.Add(new VariableInstance(update.Body.Variable.Name, update.Body.Variable.Value));
            _frameGrabber.SetVariable(update.Body.Variable.Name, update.Body.Variable.Value);

            SaveState(_state);
        }

        IEnumerator<ITask> UpdateFrameHandler(UpdateFrame update)
        {
            update.ResponsePort.Post(DefaultUpdateResponseType.Instance);

            SendNotification(_submgrPort, update);
            yield break;
        }

        IEnumerator<ITask> SetFrameHandler(SetFrame newFrame)
        {
            newFrame.ResponsePort.Post(DefaultUpdateResponseType.Instance);

            _frameGrabber.SetFrame(newFrame.Body.pixels, newFrame.Body.Size.Width, newFrame.Body.Size.Height);
            
            yield break;
        }

        IEnumerator<ITask> SetCaptureHandler(SetCapture cap)
        {
            cap.ResponsePort.Post(DefaultUpdateResponseType.Instance);

            _frameGrabber.SetCapture(cap.Body.captureImage, cap.Body.captureVariable);
            _frameGrabber.SetConnectionProperties(cap.Body.Hostname, cap.Body.Port);
            _frameGrabber.StartCapture();

            yield break;
        }

        IEnumerator<ITask> SubscribeHandler(Subscribe subscribe)
        {
            yield return Arbiter.Choice(
                SubscribeHelper(_submgrPort, subscribe.Body, subscribe.ResponsePort),
                delegate(SuccessResult success)
                {
                    LogInfo("Subscription from: " + subscribe.Body.Subscriber);
                },
                delegate(Exception e)
                {
                    LogError(e);
                }
            );
        }

        //CaptureEventArgs 
        void OnCaptureFrame(object sender, InterfaceState e)
        {
            _framePort.Post(e);
        }
        
        void FrameHandler(InterfaceState newState)
        {
            _state = newState;

            UpdateFrameRequest request = new UpdateFrameRequest();
            request.TimeStamp = newState.TimeStamp;

            UpdateFrame update = new UpdateFrame();
            update.Body = request;
            update.ResponsePort = null;

            _fwdPort.Post(update);
        }

        IEnumerator<ITask> HttpPostHandler(HttpPost post)
        {
            Fault fault = null;
            NameValueCollection collection = null;

            ReadFormData readForm = new ReadFormData(post);
            _utilitiesPort.Post(readForm);

            yield return Arbiter.Choice(
                readForm.ResultPort,
                delegate(NameValueCollection col)
                {
                    collection = col;
                },
                delegate(Exception e)
                {
                    fault = Fault.FromException(e);
                    LogError(null, "Error processing form data", fault);
                }
            );

            if (fault != null)
            {
                post.ResponsePort.Post(fault);
                yield break;
            }

            if (!string.IsNullOrEmpty(collection["Name"]))
            {
                string name = string.Empty;
                string value = string.Empty;
                try
                {
                    name = collection["Name"];
                    value = collection["Value"];
                }
                catch (Exception e)
                {
                    fault = Fault.FromException(e);
                    LogError(null, "Error reading form data", fault);
                }

                if (fault != null)
                {
                    post.ResponsePort.Post(fault);
                    yield break;
                }

                SetVariableRequest request = new SetVariableRequest();
                request.Variable.Name = name;
                request.Variable.Value = value;

                SetVariable update = new SetVariable();
                update.Body = request;

                SetVariableInternal(update);
            }
            else
            if (!string.IsNullOrEmpty(collection["program"]))
            {
                string program = string.Empty;
                try
                {
                    program = collection["program"];
                }
                catch (Exception e)
                {
                    fault = Fault.FromException(e);
                    LogError(null, "Error reading form data", fault);
                }

                if (fault != null)
                {
                    post.ResponsePort.Post(fault);
                    yield break;
                }

                if (program.Equals("Skin Color"))
                {
                    _state.XmlString = "<Skin/>";
                }
                else
                if (program.Equals("Negative"))
                {
                    _state.XmlString = "<Negative/>";
                }
                else
                if (program.Equals("Affine Transform"))
                {
                    _state.XmlString = "<Affine>\n"+
                        "  <point_2_x>171</point_2_x>\n"+
                        "  <point_3_y>236</point_3_y>\n"+
                        "  <point_4_x>320</point_4_x>\n"+
                        "  <point_1_y>14</point_1_y>\n"+
                        "  <point_3_x>3</point_3_x>\n"+
                        "  <point_2_y>15</point_2_y>\n"+
                        "  <point_4_y>236</point_4_y>\n"+
                        "  <point_1_x>144</point_1_x>\n"+
                        "</Affine>";
                }
                else
                if (program.Equals("Sobel Edges"))
                {
                    _state.XmlString = "<Sobel_Edge/>";
                }
                else
                if (program.Equals("Red Object Tracking"))
                {
                    _state.XmlString = 
                        "<RGB_Filter>\n"+
                        "  <max_value>30</max_value>\n" +
                        "  <min_value>40</min_value>\n" +
                        "  <channel>1</channel>\n" +
                        "</RGB_Filter>\n" +
                        "<Blob_Size>\n" +
                        "  <cutoff>30</cutoff>\n" +
                        "  <limit>1</limit>\n" +
                        "  <mask>FALSE</mask>\n" +
                        "  <object_size>10</object_size>\n" +
                        "</Blob_Size>\n" +
                        "<Center_of_Gravity>\n" +
                        "  <show_coord>TRUE</show_coord>\n" +
                        "  <color_index>2</color_index>\n" +
                        "  <connect_line>FALSE</connect_line>\n" +
                        "  <density>-1</density>\n" +
                        "  <overlay_source>FALSE</overlay_source>\n" +
                        "  <show_box>TRUE</show_box>\n" +
                        "  <box_size>9</box_size>\n" +
                        "  <show_cog>TRUE</show_cog>\n" +
                        "  <threshold>-1</threshold>\n" +
                        "</Center_of_Gravity>";
                }
                else
                if (program.Equals("Pseudo Coloring"))
                {
                    _state.XmlString = "<Pseudo_Color>\n" +
                        "  <auto_intensity>FALSE</auto_intensity>\n" +
                        "  <max_intensity>767</max_intensity>\n" +
                        "  <invert>FALSE</invert>\n" +
                        "</Pseudo_Color>";
                }
                else
                if (program.Equals("Flood Fill"))
                {
                    _state.XmlString = "<Flood_Fill>\n" +
                        "  <color_tolerance>100</color_tolerance>\n" +
                        "</Flood_Fill>\n" +
                        "<Blob_Separate/>";
                }
                else
                if (program.Equals("Skeleton"))
                {
                    _state.XmlString = "<Auto_Threshold>\n" +
                        "  <distance>10</distance>\n" +
                        "  <percent>50</percent>\n" +
                        "  <symmetry_percent>10</symmetry_percent>\n" +
                        "  <method>5</method>\n" +
                        "</Auto_Threshold>\n" +
                        "<Skeleton/>";
                }
                else
                if (program.Equals("Frame Averaging"))
                {
                    _state.XmlString = "<Average>\n" +
                        "  <continuious>TRUE</continuious>\n" +
                        "  <num_frames>10</num_frames>\n" +
                        "</Average>";
                }
                else
                if (program.Equals("Motion Detection"))
                {
                    _state.XmlString =
                        "<Movement>\n" +
                        "  <difference>30</difference>\n" +
                        "  <set_still_black>1</set_still_black>\n" +
                        "  <anti_auto_adjustment>FALSE</anti_auto_adjustment>\n" +
                        "  <continuious>FALSE</continuious>\n" +
                        "  <reference_frame>10</reference_frame>\n" +
                        "</Movement>";
                }
                else
                if (program.Equals("Smooth Blobs"))
                {
                    _state.XmlString =
                        "<Auto_Threshold>\n" +
                        "  <distance>10</distance>\n" +
                        "  <percent>50</percent>\n" +
                        "  <symmetry_percent>10</symmetry_percent>\n" +
                        "  <method>5</method>\n" +
                        "</Auto_Threshold>\n" +
                        "<Smooth_Hull>\n" +
                        "  <window_size>50</window_size>\n" +
                        "</Smooth_Hull>";
                }
                else
                if (program.Equals("Min Filter"))
                {
                    _state.XmlString =
                        "<Min>\n" +
                        "  <filter_size>10</filter_size>\n" +
                        "</Min>";
                }
                else
                    _state.XmlString = "";
                

                _frameGrabber.Execute(_state.XmlString);
            }
            else
                if (!string.IsNullOrEmpty(collection["program_xml"]))
            {
                string xmlString = string.Empty;
                try
                {
                    xmlString = collection["program_xml"];
                }
                catch (Exception e)
                {
                    fault = Fault.FromException(e);
                    LogError(null, "Error reading form data", fault);
                }

                if (fault != null)
                {
                    post.ResponsePort.Post(fault);
                    yield break;
                }

                _state.XmlString = xmlString;

                _frameGrabber.Execute(xmlString);
            }

            if (fault != null)
            {
                post.ResponsePort.Post(fault);
                yield break;
            }

            post.ResponsePort.Post(new HttpResponseType(HttpStatusCode.OK, _state, _transform));
            yield break;
        }
    }

    class FramePort : Port<InterfaceState> { }

    public delegate void CaptureEvent(object sender, InterfaceState e);

    public class FrameGrabber : IDisposable
    {
        private bool _capturing;
        private bool _setFrameMode = false;
        private bool _captureImage;
        private bool _captureVariable;
        private DispatcherQueue _taskQueue;
        private PortSet<InterfaceState, Exception> _capturePort = new PortSet<InterfaceState, Exception>();
        private RR_API _api = new RR_API();
        private int width, height;
        private Dictionary<String, String> _variables = new Dictionary<string,string>();

        string HOSTNAME = "localhost";
        int PORT = 6060;

        public FrameGrabber(string H, int P)
        {
            Dispatcher dispatcher = new Dispatcher(0, "FrameGrabber "+P);
            this._taskQueue = new DispatcherQueue("FrameGrabber DispatcherQueue "+P, dispatcher);

            this.StartBehavior();

            HOSTNAME = H;
            PORT = P;
        }

        public void SetConnectionProperties(string H, int P)
        {
            HOSTNAME = H;
            PORT = P;
        }

        void Connect()
        {
            if (_api.isConnected()) _api.close();

            if (!_api.isConnected())
            {
                if (_api.open(PORT))
                {
                    if (_api.connect(HOSTNAME, PORT, false))
                    {
                        Dimension d = _api.getDimension();
                        if (d != null)
                        {
                            width = d.width;
                            height = d.height;
                        }
                        else
                            width = height = 0;
                    }
                }
            }
        }

        private void StartBehavior()
        {
            Arbiter.Activate(_taskQueue,
                    Arbiter.Receive<InterfaceState>(
                        true, _capturePort, delegate(InterfaceState state)
                        {
                            // Raise the CaptureFrame event.
                            this.OnCaptureFrame(state);
                            // Capture next frame.
                            this.CaptureRoboRealmFrame(_capturePort);
                        }
                ),
                Arbiter.Receive<Exception>(
                    true, _capturePort, delegate(Exception error)
                    {
                        // Capture next frame.
                        this.CaptureRoboRealmFrame(_capturePort);
                    }
                )
            );
        }

        public event CaptureEvent CaptureFrame;

        private void OnCaptureFrame(InterfaceState state)
        {
            if (this.CaptureFrame != null)
            {
                this.CaptureFrame(this, state);
            }
        }

        public void CheckCapture()
        {
            if (this._capturing) { return; };
            Connect();
        }

        public void StartCapture()
        {
            if (this._capturing) { return; };
            this._capturing = true;
            this.CaptureRoboRealmFrame(_capturePort);
        }

        public void StopCapture()
        {
            this._capturing = false;
        }

        public void SetCapture(bool image, bool variable)
        {
            this._captureImage = image;
            this._captureVariable = variable;
        }

        public bool Capturing
        {
            get
            {
                return _capturing;
            }
        }

        public void Dispose()
        {
            if (this._taskQueue != null)
            {
                if (this._taskQueue.Dispatcher != null)
                {
                    // This will also dispose of the DispatcherQueue.
                    this._taskQueue.Dispatcher.Dispose();
                }
                else
                {
                    this._taskQueue.Dispose();
                }
                this._taskQueue = null;
            }

            _api.disconnect();
        }

        public void SetVariable(string name, string value)
        {
            if (!_api.isConnected()) Connect();

            if (_api.isConnected()) 
            {
                _api.setVariable(name, value);
            }
        }

        public String QueryVariable(string name)
        {
            string value;
            _variables.TryGetValue(name, out value);
            return value;
        }

        public void Execute(string script)
        {
            if (!_api.isConnected()) Connect();

            if (_api.isConnected())
            {
                _api.execute(script);
            }
        }

        public bool LoadProgram(string filename)
        {
            if (!_api.isConnected()) Connect();

            if (_api.isConnected())
            {
                return _api.loadProgram(filename);
            }

            return false;
        }

        public void SetFrame(byte[] pixels, int width, int height)
        {
            if (!_api.isConnected()) Connect();

            if (_api.isConnected())
            {
                int i;
              // flip BGR to RGB
              for (i=0;i<width*height*3;i+=3)
              {
                byte c = pixels[i];
                    pixels[i] = pixels[i + 2];
                    pixels[i + 2] = c;
              }
                
                _api.setImage(pixels, width, height);

                _setFrameMode = true;
                _capturePort.Post(new InterfaceState());
            }
        }

        private void CaptureRoboRealmFrame(PortSet<InterfaceState, Exception> capturePort)
        {
            if (!this._capturing) return;
            if (!_api.isConnected())
            {
                Connect();
                if (!_api.isConnected())
                {
                    capturePort.Post(new Exception("RoboRealm is not running!"));
                    return;
                }
            }

            InterfaceState newState = new InterfaceState();

            if (this._captureImage)
            {
                if ((width == 0) || (height == 0))
                {
                    Dimension d = _api.getDimension();
                    if (d != null)
                    {
                        width = d.width;
                        height = d.height;
                    }
                    else
                        width = height = 0;
                }

                if ((width == 0) || (height == 0)) return;

                BitmapData raw = null;
                newState.Image = new Bitmap(width, height);
                newState.Size = new Size(width, height);
                Bitmap frame = newState.Image;

                try
                {
                    raw = frame.LockBits(new Rectangle(Point.Empty, new Size(width, height)), ImageLockMode.ReadWrite, PixelFormat.Format24bppRgb);

                    int len = width * height * 3;
                    byte[] line = new byte[len];

                    if (!_api.isConnected())
                    {
                        if (!_api.connect(HOSTNAME, PORT, false))
                        {
                            capturePort.Post(new Exception("RoboRealm is not running!"));
                            return;
                        }
                        Dimension d = _api.getDimension();
                        if (d != null)
                        {
                            width = d.width;
                            height = d.height;
                        }
                        else
                        {
                            width = height = 0;
                        }
                    }
                    _api.getImage(line, len);

                    // we need to reverse red and blue since Windows likes BGR format instead of RGB
                    for (int i = 0; i < len; i += 3)
                    {
                        byte tmp = line[i];
                        line[i] = line[i + 2];
                        line[i + 2] = tmp;
                    }

                    System.Runtime.InteropServices.Marshal.Copy(line, 0, raw.Scan0, len);

                    frame.UnlockBits(raw);
                }
                catch (TimeoutException ex)
                {
                    if (this._capturing)
                    {
                        capturePort.Post(ex);
                        return;
                    }
                }
            }

            if (this._captureVariable)
            {
                try
                {
                    Dictionary<String, String> _newVariables = new Dictionary<string, string>();

                    // load in all variables from RR
                    List<string> v = _api.getAllVariables();
                    if (v != null)
                    {
                        for (int i = 0; i < v.Count; i += 2)
                        {
                            newState.Variables.Add(new VariableInstance(v[i], v[i + 1]));
                            _newVariables.Add(v[i], v[i + 1]);
                        }
                    }

                    _variables = _newVariables;
                }
                catch (TimeoutException ex)
                {
                    if (this._capturing)
                    {
                        capturePort.Post(ex);
                        return;
                    }
                }
            }

            // Check if the interface service is still active as it might have
            // been deactivated by another service running in another thread.
            if (!this._setFrameMode)
            {
                if (this._capturing)
                {
                    _api.waitImage();
                    capturePort.Post(newState);
                }
            }
        }
    }
}
