//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.42
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

using Microsoft.Ccr.Core;
using Microsoft.Dss.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Xml;
using GetVariableExampleState = RoboRealm.GetVariableExample;
using realm = RoboRealm.Proxy;
using W3C.Soap; // Fault

namespace RoboRealm.GetVariableExample
{
    /// <summary>
    /// Implementation class for GetVariableExample
    /// </summary>
    [DisplayName("GetVariableExample")]
    [Description("The GetVariableExample Service")]
    [Contract(Contract.Identifier)]
    public class GetVariableExampleService : DsspServiceBase
    {
        [Partner("realm", Contract = realm.Contract.Identifier, CreationPolicy = PartnerCreationPolicy.UseExistingOrCreate)]
        private realm.InterfaceOperations _realmPort = new realm.InterfaceOperations();
        private realm.InterfaceOperations _realmNotify = new realm.InterfaceOperations();

        /// <summary>
        /// _state
        /// </summary>
        private GetVariableExampleState _state = new GetVariableExampleState();
        /// <summary>
        /// _main Port
        /// </summary>
        [ServicePort("/getvariableexample", AllowMultipleInstances=false)]
        private GetVariableExampleOperations _mainPort = new GetVariableExampleOperations();
        /// <summary>
        /// Default Service Constructor
        /// </summary>
        public GetVariableExampleService(DsspServiceCreationPort creationPort) : 
                base(creationPort)
        {
        }
        
        /// <summary>
        /// Service Start
        /// </summary>
        protected override void Start()
        {
			base.Start();

			// Add service specific initialization here.
            _realmPort.Subscribe(_realmNotify);

            realm.SetCaptureRequest req = new realm.SetCaptureRequest();
            req.captureImage = false;
            req.captureVariable = true;
            req.Hostname = "localhost";
            req.Port = 6060;
            _realmPort.SetCapture(req);

            // load in a simple program into roborealm to generate some variables
            realm.ExecuteProgramRequest program = new realm.ExecuteProgramRequest();
            // note that this config does not include any display elements in
            // roborealm so you will not see the COG in RoboRealm. You can remove the next
            // lines if you just want to use the existing program in RoboRealm.
            program.Source = "<Center_of_Gravity></Center_of_Gravity>";
            _realmPort.ExecuteProgram(program);

            // listen for variable changes
            Activate(
                Arbiter.Receive<realm.UpdateFrame>(true, _realmNotify,
                delegate(realm.UpdateFrame hasframe)
                {
                    SpawnIterator(GetVariable);
                })
            );
        }
        /// <summary>
        /// Get Handler
        /// </summary>
        /// <param name="get"></param>
        /// <returns></returns>
        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public virtual IEnumerator<ITask> GetHandler(Get get)
        {
            get.ResponsePort.Post(_state);
            yield break;
        }

        public IEnumerator<ITask> GetVariable()
        {
            // called when a new frame has been captured .. this means the variables
            // may have changed. Create a query variable request to request specific
            // variables.
            realm.QueryVariablesRequest req = new realm.QueryVariablesRequest();
            req._names = new List<String>();
            req._names.Add("COG_X");
            req._names.Add("COG_Y");
            if (req != null)
            {
                // send of the request and process the results
                yield return Arbiter.Choice(
                    _realmPort.QueryVariables(req),
                    delegate(realm.QueryVariablesResponse res)
                    {
                        // for now just print the results in the command console. You could
                        // use these values to futher partner with a robotic drive system
                        // and move the robot based on COG values.
                        Console.WriteLine("COG: " + res._values[0] + "," + res._values[1]);
                    },
                    delegate(Fault f)
                    {
                        LogError(LogGroups.Console, "Could not query webcam frame", f);
                    });
            }
        }

    }
}
