//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.42
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

using Microsoft.Ccr.Core;
using Microsoft.Dss.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Xml;
using roborealmsimulation = RoboRealm.RoboRealmSimulation;
using realm = RoboRealm.Proxy;
using System.Drawing;
using System.Net;
using System.Drawing.Imaging;
using submgr = Microsoft.Dss.Services.SubscriptionManager;
using W3C.Soap;
using System.IO;

#region Simulation namespaces
using Microsoft.Robotics.Simulation;
using Microsoft.Robotics.Simulation.Engine;
using engineproxy = Microsoft.Robotics.Simulation.Engine.Proxy;
using Microsoft.Robotics.Simulation.Physics;

using drive = Microsoft.Robotics.Services.Simulation.Drive.Proxy;
using simcam = Microsoft.Robotics.Services.Simulation.Sensors.SimulatedWebcam.Proxy;
using simengine = Microsoft.Robotics.Simulation.Engine;
using webcam = Microsoft.Robotics.Services.WebCam;

using Microsoft.Robotics.PhysicalModel;
using System.ComponentModel;
using Microsoft.Dss.Core.DsspHttp;
using System.Net;
#endregion

namespace RoboRealm.RoboRealmSimulation
{
    /// <summary>
    /// Implementation class for RoboRealmSimulation
    /// </summary>
    [DisplayName("RoboRealmSimulation")]
    [Description("The RoboRealmSimulation Service")]
    [Contract(Contract.Identifier)]
    public class RoboRealmSimulationService : DsspServiceBase
    {
        [Partner("realm", Contract = realm.Contract.Identifier, CreationPolicy = PartnerCreationPolicy.UseExistingOrCreate)]
        private realm.InterfaceOperations _realmPort = new realm.InterfaceOperations();
        private realm.InterfaceOperations _realmNotify = new realm.InterfaceOperations();

        [Partner("Engine", Contract = engineproxy.Contract.Identifier, CreationPolicy = PartnerCreationPolicy.UseExistingOrCreate)]
        private engineproxy.SimulationEnginePort _engineServicePort = new engineproxy.SimulationEnginePort();

        [Partner("SubMgr", Contract = submgr.Contract.Identifier, CreationPolicy = PartnerCreationPolicy.CreateAlways)]
        submgr.SubscriptionManagerPort _subMgrPort = new submgr.SubscriptionManagerPort();

        simengine.SimulationEnginePort _notificationTarget;
        simengine.CameraEntity _entity;

        float leftWheelPower;
        float rightWheelPower;

        LegoNXTTribot robotBaseEntity = null;

        /// <summary>
        /// _state
        /// </summary>
        private webcam.WebCamState _state = new webcam.WebCamState();
        /// <summary>
        /// _main Port
        /// </summary>
        [ServicePort("/roborealmsimulation", AllowMultipleInstances=false)]
        private webcam.WebCamOperations _mainPort = new webcam.WebCamOperations();
        /// <summary>
        /// Default Service Constructor
        /// </summary>
        public RoboRealmSimulationService(DsspServiceCreationPort creationPort) : 
                base(creationPort)
        {
        }
        /// <summary>
        /// Service Start
        /// </summary>
        protected override void Start()
        {
            base.Start();

            _notificationTarget = new simengine.SimulationEnginePort();

            // issue Subscribe
            simengine.SimulationEngine.GlobalInstancePort.Subscribe(ServiceInfo.PartnerList, _notificationTarget);

            // Add service specific initialization here.
            realm.SetCaptureRequest req = new realm.SetCaptureRequest();
            req.captureImage = false;
            req.captureVariable = true;
            _realmPort.SetCapture(req);
            
            _realmPort.Subscribe(_realmNotify);

            SetupCamera();

            PopulateWorld();

            Activate(Arbiter.Receive(false, TimeoutPort(100), CheckForUpdate));
        }

        // Send an update message to ourself at an interval specified by the camera entity.
        // If the interval is 0, check once per second to see if the interval has changed but
        // don't do an update.
        void CheckForUpdate(DateTime time)
        {
            if (_entity == null)
                return; // the entity went away, do no more updates

            if (_entity.UpdateInterval != 0)
            {
                _mainPort.Post(new webcam.UpdateFrame());
                Activate(Arbiter.Receive(false, TimeoutPort(_entity.UpdateInterval), CheckForUpdate));
            }
            else
                Activate(Arbiter.Receive(false, TimeoutPort(1000), CheckForUpdate));
        }

        void DeleteEntityNotificationHandler(simengine.DeleteSimulationEntity del)
        {
            _entity = null;
        }

        [ServiceHandler(ServiceHandlerBehavior.Teardown)]
        public IEnumerator<ITask> DropHandler(DsspDefaultDrop drop)
        {
            DefaultDropHandler(drop);
            yield break;
        }

        private void SetupCamera()
        {
            // Set up initial view
            CameraView view = new CameraView();
            view.EyePosition = new Vector3(2.491269f, 0.598689f, 1.046625f);
            view.LookAtPoint = new Vector3(1.873792f, 0.40983f, 0.2830455f);
            SimulationEngine.GlobalInstancePort.Update(view);
        }

        private void PopulateWorld()
        {
            AddSky();
            AddGround();
            AddConvexMesh("street_cone.obj", new Vector3(0.7f, 1f, -2.5f));
            AddLegoNxtRobot(new Vector3(2, 0.1f, 0));
        }

        #region Environment Entities

        void AddSky()
        {
            // Add a sky using a static texture. We will use the sky texture
            // to do per pixel lighting on each simulation visual entity
            SkyEntity sky = new SkyEntity("sky.dds", "sky_diff.dds");
            SimulationEngine.GlobalInstancePort.Insert(sky);

            // Add a directional light to simulate the sun.
            LightSourceEntity sun = new LightSourceEntity();
            sun.State.Name = "Sun";
            sun.Type = LightSourceEntityType.Directional;
            sun.Color = new Vector4(0.8f, 0.8f, 0.8f, 1);
            sun.Direction = new Vector3(-1.0f, -1.0f, 0.5f);
            SimulationEngine.GlobalInstancePort.Insert(sun);
        }

        void AddGround()
        {
            HeightFieldShapeProperties hf = new HeightFieldShapeProperties("height field",
                64, // number of rows 
                100, // distance in meters, between rows
                64, // number of columns
                100, // distance in meters, between columns
                1, // scale factor to multiple height values 
                -1000); // vertical extent of the height field. Should be set to large negative values

            // create array with height samples
            hf.HeightSamples = new HeightFieldSample[hf.RowCount * hf.ColumnCount];
            for (int i = 0; i < hf.RowCount * hf.ColumnCount; i++)
            {
                hf.HeightSamples[i] = new HeightFieldSample();
                hf.HeightSamples[i].Height = (short)(Math.Sin(i * 0.01));
            }

            // create a material for the entire field. We could also specify material per sample.
            hf.Material = new MaterialProperties("ground", 0.8f, 0.5f, 0.8f);

            // insert ground entity in simulation and specify a texture
            SimulationEngine.GlobalInstancePort.Insert(new HeightFieldEntity(hf, "03RamieSc.dds"));
/*
            // For a more interesting ground uncomment this next block and comment out the code before this.
            TerrainEntity ground = new TerrainEntity(
                             "terrain.bmp",
                             "terrain_tex.jpg",
                             new MaterialProperties("ground",
                                 0.2f, // restitution
                                 0.5f, // dynamic friction
                                 0.5f) // static friction
                             );
            SimulationEngine.GlobalInstancePort.Insert(ground);
            */
        }

        private void AddConvexMesh(string name, Vector3 pos)
        {
            Shape cshape = null;
            SimplifiedConvexMeshEnvironmentEntity centity = new SimplifiedConvexMeshEnvironmentEntity(pos,
                                                                        name,
                                                                        cshape);
            centity.State.MassDensity.Mass = 30;
            centity.State.Name = "Convex mesh:" + name + ":" + Guid.NewGuid().ToString();
            SimulationEngine.GlobalInstancePort.Insert(centity);
        }

        #endregion

        #region Robot Entities

        private CameraEntity CreateCamera()
        {
            // low resolution, wide Field of View
            CameraEntity cam = new CameraEntity(320, 240);
            cam.State.Name = "robocam";
            // just on top of the bot
            cam.State.Pose.Position = new Vector3(0.0f, 0.5f, 0.0f);
            // camera renders in an offline buffer at each frame
            // required for service
            cam.IsRealTimeCamera = true;
            cam.UpdateInterval = 100;

            // Start simulated webcam service
            simcam.Contract.CreateService(
                ConstructorPort,
                Microsoft.Robotics.Simulation.Partners.CreateEntityPartner(
                    "http://localhost/" + cam.State.Name)
            );

            return cam;
        }

        #endregion

        #region Lego NXT
        void AddLegoNxtRobot(Vector3 position)
        {
            robotBaseEntity = CreateLegoNxtMotorBase(ref position);

            // create Camera Entity ans start SimulatedWebcam service
            CameraEntity cam1 = CreateCamera();
            // insert as child of motor base
            robotBaseEntity.InsertEntity(cam1);

            _entity = cam1;

            // Finaly insert the motor base and its two children 
            // to the simulation
            SimulationEngine.GlobalInstancePort.Insert(robotBaseEntity);

            robotBaseEntity.SetMotorTorque((float)0.15, (float)0.0);
        }

        private LegoNXTTribot CreateLegoNxtMotorBase(ref Vector3 position)
        {
            // use supplied entity that creates a motor base 
            // with 2 active wheels and one caster
            LegoNXTTribot robotBaseEntity = new LegoNXTTribot(position);

            // specify mesh. 
            robotBaseEntity.State.Assets.Mesh = "LegoNXTTribot.bos";

            // the name below must match manifest
            robotBaseEntity.State.Name = "LegoNXTMotorBase";

            // Start simulated arcos motor service
            CreateService(
                drive.Contract.Identifier,
                Microsoft.Robotics.Simulation.Partners.CreateEntityPartner(
                    "http://localhost/" + robotBaseEntity.State.Name)
            );
            return robotBaseEntity;
        }

        #endregion

        #region DSSP Handlers
        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public IEnumerator<ITask> HttpGetHandler(HttpGet get)
        {
            get.ResponsePort.Post(new HttpResponseType(HttpStatusCode.OK, _state));
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public IEnumerator<ITask> ReplaceHandler(Replace replace)
        {
            replace.ResponsePort.Post(new DefaultReplaceResponseType());
            yield break;
        }

        [ServiceHandler(ServiceHandlerBehavior.Exclusive)]
        public IEnumerator<ITask> UpdateFrameHandler(webcam.UpdateFrame update)
        {
            if (_entity != null)
            {
                PortSet<Bitmap, Exception> result = new PortSet<Bitmap, Exception>();
                _entity.CaptureScene(System.Drawing.Imaging.ImageFormat.MemoryBmp, result);

                yield return Arbiter.Choice(result,
                    delegate(Bitmap b)
                    {
                        _state.LastFrameUpdate = DateTime.Now;
                        _state.Image = b;

                        BitmapData raw = null;

                        Size size = _state.Image.Size;

                        try
                        {
                            raw = _state.Image.LockBits(new Rectangle(Point.Empty, size), ImageLockMode.ReadOnly, PixelFormat.Format24bppRgb);
                            realm.SetFrameRequest newFrame = new realm.SetFrameRequest();
                            int byteLen = size.Width * size.Height * 3;
                            newFrame.pixels = new byte[byteLen];
                            newFrame.Size = new Size(size.Width, size.Height);
                            System.Runtime.InteropServices.Marshal.Copy(raw.Scan0, newFrame.pixels, 0, byteLen);

                            _realmPort.SetFrame(newFrame);
                            
                            SpawnIterator(GetVariable);
                        }
                        catch (Exception ex)
                        {
                        }
                        finally
                        {
                            if (raw != null)
                            {
                                _state.Image.UnlockBits(raw);
                            }
                        }
                        //frame.Save("C:\\temp\\test.jpg");
                    },
                    delegate(Exception ex)
                    {
                        update.ResponsePort.Post(Fault.FromException(ex));
                    });
            }
        }

        public IEnumerator<ITask> GetVariable()
        {
            realm.QueryVariablesRequest req = new realm.QueryVariablesRequest();
            req._names = new List<String>();
            req._names.Add("LEFT_MOTOR");
            req._names.Add("RIGHT_MOTOR");
            if (req != null)
            {
                yield return Arbiter.Choice(
                    _realmPort.QueryVariables(req),
                    delegate(realm.QueryVariablesResponse res)
                    {
                        if ((res._values[0] != null) && (res._values[1] != null))
                        {
                            leftWheelPower = (float)(Convert.ToInt32(res._values[0]) - 128.0f) / 128.0f;
                            rightWheelPower = (float)(Convert.ToInt32(res._values[1]) - 128.0f) / 128.0f;
                            robotBaseEntity.SetMotorTorque((float)leftWheelPower, (float)rightWheelPower);
                        }
                    },
                    delegate(Fault f)
                    {
                        LogError(LogGroups.Console, "Could not query webcam frame", f);
                    });
            }
        }

        [ServiceHandler(ServiceHandlerBehavior.Concurrent)]
        public IEnumerator<ITask> QueryFrameHandler(webcam.QueryFrame query)
        {
            if (_state.Image == null)
            {
                query.ResponsePort.Post(new webcam.QueryFrameResponse());
                yield break;
            }

            Size size = new Size((int)query.Body.Size.X, (int)query.Body.Size.Y);

            if (query.Body.Format == Guid.Empty)
            {
                // raw image requested;
                BitmapData raw = null;

                // size not specified
                if (size.Width == 0)
                    size = _state.Image.Size;

                try
                {
                    raw = _state.Image.LockBits(new Rectangle(Point.Empty, size),
                        ImageLockMode.ReadOnly, PixelFormat.Format24bppRgb);

                    int byteSize = raw.Height * raw.Stride;

                    webcam.QueryFrameResponse response = new webcam.QueryFrameResponse();

                    response.TimeStamp = _state.LastFrameUpdate;
                    response.Frame = new byte[byteSize];
                    response.Size = new Size(raw.Width, raw.Height);
                    response.Format = Guid.Empty;

                    System.Runtime.InteropServices.Marshal.Copy(raw.Scan0, response.Frame, 0, byteSize);

                    query.ResponsePort.Post(response);
                }
                catch (Exception ex)
                {
                    query.ResponsePort.Post(Fault.FromException(ex));
                }
                finally
                {
                    if (raw != null)
                    {
                        _state.Image.UnlockBits(raw);
                    }
                }
            }
            else
            {
                ImageFormat format = new ImageFormat(query.Body.Format);

                using (MemoryStream stream = new MemoryStream())
                {
                    if (size == _state.Image.Size ||
                        size.Width == 0 ||
                        size.Height == 0 ||
                        size.Width >= _state.Image.Width ||
                        size.Height >= _state.Image.Height)
                    {
                        size = _state.Image.Size;
                        _state.Image.Save(stream, format);
                    }
                    else
                    {
                        using (Bitmap temp = new Bitmap(
                            _state.Image, size))
                        {
                            temp.Save(stream, format);
                        }
                    }

                    webcam.QueryFrameResponse response = new webcam.QueryFrameResponse();
                    response.TimeStamp = _state.LastFrameUpdate;
                    response.Frame = new byte[(int)stream.Length];
                    response.Size = size;
                    response.Format = format.Guid;

                    stream.Position = 0;
                    stream.Read(response.Frame, 0, response.Frame.Length);

                    query.ResponsePort.Post(response);
                }
            }
            yield break;
        }

        #endregion
    }
}
