<?xml version="1.0" encoding="utf-8" ?>
<!--
//  This file is part of the Microsoft Robotics SDK Code Samples.
// 
//  Copyright (C) Microsoft Corporation.  All rights reserved.
//
//  $File: interface.xslt $ $Revision: 1 $
-->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:wc="http://www.roborealm.com/2007/05/interface.html">

	<xsl:import href="/resources/dss/Microsoft.Dss.Runtime.Home.MasterPage.xslt" />
	<xsl:template match="/">
		<xsl:call-template name="MasterPage">
			<xsl:with-param name="serviceName">
			RoboRealm Interface
		</xsl:with-param>
		<xsl:with-param name="description">
			RoboRealm Viewer
		</xsl:with-param>
		<xsl:with-param name="head">
			<style>
				.storeuserData {behavior:url(#default#userData);}
			</style>
			<script language="javascript" type="text/javascript">
					<![CDATA[
          <!--// hide from older browsers
    var refreshTime = 250;
    var targetUrl = self.location.href + "/jpeg";
    var feedRunning = false;
    var frameCount;
    var startTime;
    var sStore = "DssInterface";
    var sPersistObject = "txtInterval";
    var fLoaded = false;
    
    function loadImage()
    {
        var img = document.all("TargetImg");
        var timeStamp = new Date();
        
        img.src = targetUrl + "?time=" + timeStamp.getTime();
        
        frameCount++;
        if (frameCount % 4 == 0)
        {
            var now = new Date();
            var interval = now.valueOf() - startTime.valueOf();
            document.all("spanFrameRate").innerText = (1000 * frameCount / interval).toFixed(1) + " fps"
        }
    }
    
    function onImageLoad()
    {
        document.all("TargetImg").alt = "Camera Image";
        
        //fire the function every refreshRate
        if (feedRunning)
        {
            setTimeout("loadImage()", refreshTime);        
        }
    }
    
    function onImageError()
    {
        document.all("TargetImg").alt = "Camera Image - failed to load";
        stopFeed();
    }
    
    function startFeed()
    {
        feedRunning = true;
        frameCount = 0;
        startTime = new Date();
        loadImage();
        
        document.all("btnStart").disabled = true;
        //document.all("btnRefresh").disabled = true;
        document.all("btnStop").disabled = false;
        
        saveInput();
    }
    
    function stopFeed()
    {
        feedRunning = false;

        document.all("btnStart").disabled = false;
        //document.all("btnRefresh").disabled = false;
        document.all("btnStop").disabled = true;
        
        document.all("spanFrameRate").innerText = "Stopped";
        saveInput();
    }
    
    function setRefresh(value)
    {
        var data = parseInt(value);
        
        if (isNaN(data))
        {
            document.all(sPersistObject).value = refreshTime;
        }
        else
        {
            refreshTime = data;
        }
        frameCount = 0;
        startTime = new Date();
        
        saveInput();
    }
    
    function saveInput()
    {
        if (fLoaded)
        {
            var oPersist = document.all(sPersistObject);
            
            oPersist.setAttribute("sInterval", oPersist.value);
            oPersist.setAttribute("sRunning", feedRunning);
            
            oPersist.save(sStore);
        }
    }
    
    function loadInput()
    {
        var oPersist = document.all(sPersistObject);
        
        oPersist.load(sStore);
        
        var vValue = oPersist.getAttribute("sInterval");
        if (vValue != null)
        {
            var refresh = parseInt(vValue);
            if (!isNaN(refresh))
            {
                oPersist.value = refresh;
                setRefresh(refresh);
            }
        }
        vValue = oPersist.getAttribute("sRunning");
        if (vValue == "true")
        {
            startFeed();
        }
        else
        {
            stopFeed();
        }
        fLoaded = true;
    }
    
    function bodyOnLoad()
    {
      document.all("TargetImg").src = self.location.href + "/jpeg";
      loadInput();
    }
    
    // -->
]]>
			</script>
		</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

		<xsl:template match="/wc:InterfaceState">

				<form id="oForm" action="" method="post">
				<table>
					<tr class="odd">
						<th colspan="2">
							Camera
						</th>
					</tr>
					<tr class="even">
						<td colspan="2" align="left">
							<img id="TargetImg" name="TargetImg" src="/roborealm/jpeg" 
								alt="Camera Image" onload="onImageLoad()" onerror="onImageError()">
							<xsl:attribute name="width">
									<xsl:value-of select="wc:Size/wc:Width"/>
								</xsl:attribute>
								<xsl:attribute name="height">
									<xsl:value-of select="wc:Size/wc:Height"/>
							</xsl:attribute>
							</img>
						</td>
					</tr>
					<tr class="even">
						<td></td>
						<td>
							<button id="btnStart" name="btnStart" onclick="startFeed()">
								Start
							</button>
							<button id="btnStop" name="btnStop" onclick="stopFeed()" disabled="disabled">
								Stop
							</button>
							Refresh <input type="Text" class="storeuserData" id="txtInterval"  name="Interval" value="250" size="1" onchange="setRefresh(this.value)" />
							Frame Rate
							<span id="spanFrameRate">Stopped</span>
						</td>
					</tr>
					<tr class="odd">
						<th colspan="2">
							Set Variable
					</th>
					</tr>
					<tr>
						<td>
							Name
						</td>
						<td>
							<input type="Text" class="storeuserData" name="name" size="50"/>
						</td>
					</tr>
					<tr>
						<td>
							Value
						</td>
						<td>
							<input type="Text" class="storeuserData" name="value" size="50"/>
						</td>
					</tr>
					<tr class="even">
						<td></td>
						<td>
							<input type="submit" name="Save" Value="Save"/>
						</td>
					</tr>
					<tr class="odd">
						<th colspan="2">
							Variables
							<input type="submit" name="Refresh" Value="Refresh"/>
						</th>
					</tr>
					<xsl:apply-templates select="wc:Variables"/>
					<tr class="odd">
						<th colspan="2">
							Example Programs
						</th>
					</tr>
					<tr class="even">
						<td></td>
						<td>
							<select name="program">
								<option></option>
								<option>None</option>
								<option>Sobel Edges</option>
								<option>Skin Color</option>
								<option>Negative</option>
								<option>Affine Transform</option>
								<option>Pseudo Coloring</option>
								<option>Flood Fill</option>
								<option>Skeleton</option>
								<option>Frame Averaging</option>
								<option>Motion Detection</option>
								<option>Smooth Blobs</option>
								<option>Min Filter</option>
								<option>Red Object Tracking</option>
								</select>
							<input type="submit" name="Select" Value="Select"/>
						</td>
					</tr>
					<tr class="odd">
						<th colspan="2">
							Program XML
						</th>
					</tr>
					<tr class="even">
						<td colspan="2">
							<textarea cols="70" rows="7" name="program_xml">
								<xsl:value-of select="wc:XmlString"/>
							</textarea>
							<input type="submit" name="Save" Value="Save"/>
						</td>
					</tr>
				</table>
				</form>
	</xsl:template>

	<xsl:template match="wc:Variables">
		<xsl:apply-templates select="wc:VariableInstance"/>
	</xsl:template>

	<xsl:template match="wc:VariableInstance">
		<tr>
			<td>
				<xsl:value-of select="wc:Name"/>
			</td>
			<td>
				<xsl:value-of select="wc:Value"/>
			</td>
		</tr>
	</xsl:template>

</xsl:stylesheet>