﻿using System;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.Core.Transforms;

#if NET_CF20
[assembly: ServiceDeclaration(DssServiceDeclaration.Transform, SourceAssemblyKey = @"cf.roborealm.interface.y2007.m05, version=0.0.0.0, culture=neutral, publickeytoken=ded25c5f37b5f5a1")]
#else
[assembly: ServiceDeclaration(DssServiceDeclaration.Transform, SourceAssemblyKey = @"roborealm.interface.y2007.m05, version=0.0.0.0, culture=neutral, publickeytoken=ded25c5f37b5f5a1")]
#endif
#if !URT_MINCLR
[assembly: System.Security.SecurityTransparent]
[assembly: System.Security.AllowPartiallyTrustedCallers]
#endif

namespace Dss.Transforms.TransformRoboRealm
{

    public class Transforms: TransformBase
    {

        public static object Transform_RoboRealm_Proxy_InterfaceState_TO_RoboRealm_InterfaceState(object transformFrom)
        {
            RoboRealm.InterfaceState target = new RoboRealm.InterfaceState();
            RoboRealm.Proxy.InterfaceState from = transformFrom as RoboRealm.Proxy.InterfaceState;
            target.Size = from.Size;

            // copy IEnumerable Variables
            if (from.Variables != null)
            {
                target.Variables = new System.Collections.Generic.List<RoboRealm.VariableInstance>();
                foreach(RoboRealm.Proxy.VariableInstance elem in from.Variables)
                {
                    target.Variables.Add((elem == null) ? null : (RoboRealm.VariableInstance)Transform_RoboRealm_Proxy_VariableInstance_TO_RoboRealm_VariableInstance(elem));
                }
            }
            target.XmlString = from.XmlString;
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_InterfaceState_TO_RoboRealm_Proxy_InterfaceState(object transformFrom)
        {
            RoboRealm.Proxy.InterfaceState target = new RoboRealm.Proxy.InterfaceState();
            RoboRealm.InterfaceState from = transformFrom as RoboRealm.InterfaceState;
            target.Size = from.Size;

            // copy IEnumerable Variables
            if (from.Variables != null)
            {
                target.Variables = new System.Collections.Generic.List<RoboRealm.Proxy.VariableInstance>();
                foreach(RoboRealm.VariableInstance elem in from.Variables)
                {
                    target.Variables.Add((elem == null) ? null : (RoboRealm.Proxy.VariableInstance)Transform_RoboRealm_VariableInstance_TO_RoboRealm_Proxy_VariableInstance(elem));
                }
            }
            target.XmlString = from.XmlString;
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_QueryFrameRequest_TO_RoboRealm_QueryFrameRequest(object transformFrom)
        {
            RoboRealm.QueryFrameRequest target = new RoboRealm.QueryFrameRequest();
            RoboRealm.Proxy.QueryFrameRequest from = transformFrom as RoboRealm.Proxy.QueryFrameRequest;
            target.Format = from.Format;
            target.Size = from.Size;
            return target;
        }


        public static object Transform_RoboRealm_QueryFrameRequest_TO_RoboRealm_Proxy_QueryFrameRequest(object transformFrom)
        {
            RoboRealm.Proxy.QueryFrameRequest target = new RoboRealm.Proxy.QueryFrameRequest();
            RoboRealm.QueryFrameRequest from = transformFrom as RoboRealm.QueryFrameRequest;
            target.Format = from.Format;
            target.Size = from.Size;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_QueryFrameResponse_TO_RoboRealm_QueryFrameResponse(object transformFrom)
        {
            RoboRealm.QueryFrameResponse target = new RoboRealm.QueryFrameResponse();
            RoboRealm.Proxy.QueryFrameResponse from = transformFrom as RoboRealm.Proxy.QueryFrameResponse;
            target.Format = from.Format;
            target.Size = from.Size;

            // copy System.Byte[] target.Frame = from.Frame
            if (from.Frame != null)
            {
                target.Frame = new System.Byte[from.Frame.GetLength(0)];

                System.Buffer.BlockCopy(from.Frame, 0, target.Frame, 0, from.Frame.GetLength(0));
            }
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_QueryFrameResponse_TO_RoboRealm_Proxy_QueryFrameResponse(object transformFrom)
        {
            RoboRealm.Proxy.QueryFrameResponse target = new RoboRealm.Proxy.QueryFrameResponse();
            RoboRealm.QueryFrameResponse from = transformFrom as RoboRealm.QueryFrameResponse;
            target.Format = from.Format;
            target.Size = from.Size;

            // copy System.Byte[] target.Frame = from.Frame
            if (from.Frame != null)
            {
                target.Frame = new System.Byte[from.Frame.GetLength(0)];

                System.Buffer.BlockCopy(from.Frame, 0, target.Frame, 0, from.Frame.GetLength(0));
            }
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_QueryVariableRequest_TO_RoboRealm_QueryVariableRequest(object transformFrom)
        {
            RoboRealm.QueryVariableRequest target = new RoboRealm.QueryVariableRequest();
            RoboRealm.Proxy.QueryVariableRequest from = transformFrom as RoboRealm.Proxy.QueryVariableRequest;
            target.Name = from.Name;
            return target;
        }


        public static object Transform_RoboRealm_QueryVariableRequest_TO_RoboRealm_Proxy_QueryVariableRequest(object transformFrom)
        {
            RoboRealm.Proxy.QueryVariableRequest target = new RoboRealm.Proxy.QueryVariableRequest();
            RoboRealm.QueryVariableRequest from = transformFrom as RoboRealm.QueryVariableRequest;
            target.Name = from.Name;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_QueryVariableResponse_TO_RoboRealm_QueryVariableResponse(object transformFrom)
        {
            RoboRealm.QueryVariableResponse target = new RoboRealm.QueryVariableResponse();
            RoboRealm.Proxy.QueryVariableResponse from = transformFrom as RoboRealm.Proxy.QueryVariableResponse;
            target.Name = from.Name;
            target.Value = from.Value;
            return target;
        }


        public static object Transform_RoboRealm_QueryVariableResponse_TO_RoboRealm_Proxy_QueryVariableResponse(object transformFrom)
        {
            RoboRealm.Proxy.QueryVariableResponse target = new RoboRealm.Proxy.QueryVariableResponse();
            RoboRealm.QueryVariableResponse from = transformFrom as RoboRealm.QueryVariableResponse;
            target.Name = from.Name;
            target.Value = from.Value;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_QueryVariablesRequest_TO_RoboRealm_QueryVariablesRequest(object transformFrom)
        {
            RoboRealm.QueryVariablesRequest target = new RoboRealm.QueryVariablesRequest();
            RoboRealm.Proxy.QueryVariablesRequest from = transformFrom as RoboRealm.Proxy.QueryVariablesRequest;

            // copy IEnumerable _names
            if (from._names != null)
            {
                target._names = new System.Collections.Generic.List<System.String>();
                foreach(System.String elem in from._names)
                {
                    target._names.Add(elem);
                }
            }
            return target;
        }


        public static object Transform_RoboRealm_QueryVariablesRequest_TO_RoboRealm_Proxy_QueryVariablesRequest(object transformFrom)
        {
            RoboRealm.Proxy.QueryVariablesRequest target = new RoboRealm.Proxy.QueryVariablesRequest();
            RoboRealm.QueryVariablesRequest from = transformFrom as RoboRealm.QueryVariablesRequest;

            // copy IEnumerable _names
            if (from._names != null)
            {
                target._names = new System.Collections.Generic.List<System.String>();
                foreach(System.String elem in from._names)
                {
                    target._names.Add(elem);
                }
            }
            return target;
        }


        public static object Transform_RoboRealm_Proxy_QueryVariablesResponse_TO_RoboRealm_QueryVariablesResponse(object transformFrom)
        {
            RoboRealm.QueryVariablesResponse target = new RoboRealm.QueryVariablesResponse();
            RoboRealm.Proxy.QueryVariablesResponse from = transformFrom as RoboRealm.Proxy.QueryVariablesResponse;

            // copy IEnumerable _values
            if (from._values != null)
            {
                target._values = new System.Collections.Generic.List<System.String>();
                foreach(System.String elem in from._values)
                {
                    target._values.Add(elem);
                }
            }
            return target;
        }


        public static object Transform_RoboRealm_QueryVariablesResponse_TO_RoboRealm_Proxy_QueryVariablesResponse(object transformFrom)
        {
            RoboRealm.Proxy.QueryVariablesResponse target = new RoboRealm.Proxy.QueryVariablesResponse();
            RoboRealm.QueryVariablesResponse from = transformFrom as RoboRealm.QueryVariablesResponse;

            // copy IEnumerable _values
            if (from._values != null)
            {
                target._values = new System.Collections.Generic.List<System.String>();
                foreach(System.String elem in from._values)
                {
                    target._values.Add(elem);
                }
            }
            return target;
        }


        public static object Transform_RoboRealm_Proxy_UpdateFrameRequest_TO_RoboRealm_UpdateFrameRequest(object transformFrom)
        {
            RoboRealm.UpdateFrameRequest target = new RoboRealm.UpdateFrameRequest();
            RoboRealm.Proxy.UpdateFrameRequest from = transformFrom as RoboRealm.Proxy.UpdateFrameRequest;
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_UpdateFrameRequest_TO_RoboRealm_Proxy_UpdateFrameRequest(object transformFrom)
        {
            RoboRealm.Proxy.UpdateFrameRequest target = new RoboRealm.Proxy.UpdateFrameRequest();
            RoboRealm.UpdateFrameRequest from = transformFrom as RoboRealm.UpdateFrameRequest;
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_SetFrameRequest_TO_RoboRealm_SetFrameRequest(object transformFrom)
        {
            RoboRealm.SetFrameRequest target = new RoboRealm.SetFrameRequest();
            RoboRealm.Proxy.SetFrameRequest from = transformFrom as RoboRealm.Proxy.SetFrameRequest;
            target.Format = from.Format;
            target.Size = from.Size;

            // copy System.Byte[] target.pixels = from.pixels
            if (from.pixels != null)
            {
                target.pixels = new System.Byte[from.pixels.GetLength(0)];

                System.Buffer.BlockCopy(from.pixels, 0, target.pixels, 0, from.pixels.GetLength(0));
            }
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_SetFrameRequest_TO_RoboRealm_Proxy_SetFrameRequest(object transformFrom)
        {
            RoboRealm.Proxy.SetFrameRequest target = new RoboRealm.Proxy.SetFrameRequest();
            RoboRealm.SetFrameRequest from = transformFrom as RoboRealm.SetFrameRequest;
            target.Format = from.Format;
            target.Size = from.Size;

            // copy System.Byte[] target.pixels = from.pixels
            if (from.pixels != null)
            {
                target.pixels = new System.Byte[from.pixels.GetLength(0)];

                System.Buffer.BlockCopy(from.pixels, 0, target.pixels, 0, from.pixels.GetLength(0));
            }
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_SetVariableRequest_TO_RoboRealm_SetVariableRequest(object transformFrom)
        {
            RoboRealm.SetVariableRequest target = new RoboRealm.SetVariableRequest();
            RoboRealm.Proxy.SetVariableRequest from = transformFrom as RoboRealm.Proxy.SetVariableRequest;
            target.Variable = (from.Variable == null) ? null : (RoboRealm.VariableInstance)Transform_RoboRealm_Proxy_VariableInstance_TO_RoboRealm_VariableInstance(from.Variable);
            return target;
        }


        public static object Transform_RoboRealm_SetVariableRequest_TO_RoboRealm_Proxy_SetVariableRequest(object transformFrom)
        {
            RoboRealm.Proxy.SetVariableRequest target = new RoboRealm.Proxy.SetVariableRequest();
            RoboRealm.SetVariableRequest from = transformFrom as RoboRealm.SetVariableRequest;
            target.Variable = (from.Variable == null) ? null : (RoboRealm.Proxy.VariableInstance)Transform_RoboRealm_VariableInstance_TO_RoboRealm_Proxy_VariableInstance(from.Variable);
            return target;
        }


        public static object Transform_RoboRealm_Proxy_LoadProgramRequest_TO_RoboRealm_LoadProgramRequest(object transformFrom)
        {
            RoboRealm.LoadProgramRequest target = new RoboRealm.LoadProgramRequest();
            RoboRealm.Proxy.LoadProgramRequest from = transformFrom as RoboRealm.Proxy.LoadProgramRequest;
            target.Filename = from.Filename;
            return target;
        }


        public static object Transform_RoboRealm_LoadProgramRequest_TO_RoboRealm_Proxy_LoadProgramRequest(object transformFrom)
        {
            RoboRealm.Proxy.LoadProgramRequest target = new RoboRealm.Proxy.LoadProgramRequest();
            RoboRealm.LoadProgramRequest from = transformFrom as RoboRealm.LoadProgramRequest;
            target.Filename = from.Filename;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_LoadProgramResponse_TO_RoboRealm_LoadProgramResponse(object transformFrom)
        {
            RoboRealm.LoadProgramResponse target = new RoboRealm.LoadProgramResponse();
            RoboRealm.Proxy.LoadProgramResponse from = transformFrom as RoboRealm.Proxy.LoadProgramResponse;
            target.Error = from.Error;
            return target;
        }


        public static object Transform_RoboRealm_LoadProgramResponse_TO_RoboRealm_Proxy_LoadProgramResponse(object transformFrom)
        {
            RoboRealm.Proxy.LoadProgramResponse target = new RoboRealm.Proxy.LoadProgramResponse();
            RoboRealm.LoadProgramResponse from = transformFrom as RoboRealm.LoadProgramResponse;
            target.Error = from.Error;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_ExecuteProgramRequest_TO_RoboRealm_ExecuteProgramRequest(object transformFrom)
        {
            RoboRealm.ExecuteProgramRequest target = new RoboRealm.ExecuteProgramRequest();
            RoboRealm.Proxy.ExecuteProgramRequest from = transformFrom as RoboRealm.Proxy.ExecuteProgramRequest;
            target.Source = from.Source;
            return target;
        }


        public static object Transform_RoboRealm_ExecuteProgramRequest_TO_RoboRealm_Proxy_ExecuteProgramRequest(object transformFrom)
        {
            RoboRealm.Proxy.ExecuteProgramRequest target = new RoboRealm.Proxy.ExecuteProgramRequest();
            RoboRealm.ExecuteProgramRequest from = transformFrom as RoboRealm.ExecuteProgramRequest;
            target.Source = from.Source;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_ExecuteProgramResponse_TO_RoboRealm_ExecuteProgramResponse(object transformFrom)
        {
            RoboRealm.ExecuteProgramResponse target = new RoboRealm.ExecuteProgramResponse();
            RoboRealm.Proxy.ExecuteProgramResponse from = transformFrom as RoboRealm.Proxy.ExecuteProgramResponse;
            target.Error = from.Error;
            return target;
        }


        public static object Transform_RoboRealm_ExecuteProgramResponse_TO_RoboRealm_Proxy_ExecuteProgramResponse(object transformFrom)
        {
            RoboRealm.Proxy.ExecuteProgramResponse target = new RoboRealm.Proxy.ExecuteProgramResponse();
            RoboRealm.ExecuteProgramResponse from = transformFrom as RoboRealm.ExecuteProgramResponse;
            target.Error = from.Error;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_SetCaptureRequest_TO_RoboRealm_SetCaptureRequest(object transformFrom)
        {
            RoboRealm.SetCaptureRequest target = new RoboRealm.SetCaptureRequest();
            RoboRealm.Proxy.SetCaptureRequest from = transformFrom as RoboRealm.Proxy.SetCaptureRequest;
            target.captureVariable = from.captureVariable;
            target.captureImage = from.captureImage;
            return target;
        }


        public static object Transform_RoboRealm_SetCaptureRequest_TO_RoboRealm_Proxy_SetCaptureRequest(object transformFrom)
        {
            RoboRealm.Proxy.SetCaptureRequest target = new RoboRealm.Proxy.SetCaptureRequest();
            RoboRealm.SetCaptureRequest from = transformFrom as RoboRealm.SetCaptureRequest;
            target.captureVariable = from.captureVariable;
            target.captureImage = from.captureImage;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_VariableInstance_TO_RoboRealm_VariableInstance(object transformFrom)
        {
            RoboRealm.VariableInstance target = new RoboRealm.VariableInstance();
            RoboRealm.Proxy.VariableInstance from = transformFrom as RoboRealm.Proxy.VariableInstance;
            target.Name = from.Name;
            target.Value = from.Value;
            return target;
        }


        public static object Transform_RoboRealm_VariableInstance_TO_RoboRealm_Proxy_VariableInstance(object transformFrom)
        {
            RoboRealm.Proxy.VariableInstance target = new RoboRealm.Proxy.VariableInstance();
            RoboRealm.VariableInstance from = transformFrom as RoboRealm.VariableInstance;
            target.Name = from.Name;
            target.Value = from.Value;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_SetFrameResponse_TO_RoboRealm_SetFrameResponse(object transformFrom)
        {
            RoboRealm.SetFrameResponse target = new RoboRealm.SetFrameResponse();
            RoboRealm.Proxy.SetFrameResponse from = transformFrom as RoboRealm.Proxy.SetFrameResponse;
            target.Format = from.Format;
            target.Size = from.Size;

            // copy System.Byte[] target.Frame = from.Frame
            if (from.Frame != null)
            {
                target.Frame = new System.Byte[from.Frame.GetLength(0)];

                System.Buffer.BlockCopy(from.Frame, 0, target.Frame, 0, from.Frame.GetLength(0));
            }
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_SetFrameResponse_TO_RoboRealm_Proxy_SetFrameResponse(object transformFrom)
        {
            RoboRealm.Proxy.SetFrameResponse target = new RoboRealm.Proxy.SetFrameResponse();
            RoboRealm.SetFrameResponse from = transformFrom as RoboRealm.SetFrameResponse;
            target.Format = from.Format;
            target.Size = from.Size;

            // copy System.Byte[] target.Frame = from.Frame
            if (from.Frame != null)
            {
                target.Frame = new System.Byte[from.Frame.GetLength(0)];

                System.Buffer.BlockCopy(from.Frame, 0, target.Frame, 0, from.Frame.GetLength(0));
            }
            target.TimeStamp = from.TimeStamp;
            return target;
        }


        public static object Transform_RoboRealm_Proxy_SetCaptureResponse_TO_RoboRealm_SetCaptureResponse(object transformFrom)
        {
            RoboRealm.SetCaptureResponse target = new RoboRealm.SetCaptureResponse();
            RoboRealm.Proxy.SetCaptureResponse from = transformFrom as RoboRealm.Proxy.SetCaptureResponse;
            target.captureVariable = from.captureVariable;
            target.captureImage = from.captureImage;
            return target;
        }


        public static object Transform_RoboRealm_SetCaptureResponse_TO_RoboRealm_Proxy_SetCaptureResponse(object transformFrom)
        {
            RoboRealm.Proxy.SetCaptureResponse target = new RoboRealm.Proxy.SetCaptureResponse();
            RoboRealm.SetCaptureResponse from = transformFrom as RoboRealm.SetCaptureResponse;
            target.captureVariable = from.captureVariable;
            target.captureImage = from.captureImage;
            return target;
        }

        static Transforms()
        {
            Register();
        }
        public static void Register()
        {
            AddProxyTransform(typeof(RoboRealm.Proxy.InterfaceState), Transform_RoboRealm_Proxy_InterfaceState_TO_RoboRealm_InterfaceState);
            AddSourceTransform(typeof(RoboRealm.InterfaceState), Transform_RoboRealm_InterfaceState_TO_RoboRealm_Proxy_InterfaceState);
            AddProxyTransform(typeof(RoboRealm.Proxy.QueryFrameRequest), Transform_RoboRealm_Proxy_QueryFrameRequest_TO_RoboRealm_QueryFrameRequest);
            AddSourceTransform(typeof(RoboRealm.QueryFrameRequest), Transform_RoboRealm_QueryFrameRequest_TO_RoboRealm_Proxy_QueryFrameRequest);
            AddProxyTransform(typeof(RoboRealm.Proxy.QueryFrameResponse), Transform_RoboRealm_Proxy_QueryFrameResponse_TO_RoboRealm_QueryFrameResponse);
            AddSourceTransform(typeof(RoboRealm.QueryFrameResponse), Transform_RoboRealm_QueryFrameResponse_TO_RoboRealm_Proxy_QueryFrameResponse);
            AddProxyTransform(typeof(RoboRealm.Proxy.QueryVariableRequest), Transform_RoboRealm_Proxy_QueryVariableRequest_TO_RoboRealm_QueryVariableRequest);
            AddSourceTransform(typeof(RoboRealm.QueryVariableRequest), Transform_RoboRealm_QueryVariableRequest_TO_RoboRealm_Proxy_QueryVariableRequest);
            AddProxyTransform(typeof(RoboRealm.Proxy.QueryVariableResponse), Transform_RoboRealm_Proxy_QueryVariableResponse_TO_RoboRealm_QueryVariableResponse);
            AddSourceTransform(typeof(RoboRealm.QueryVariableResponse), Transform_RoboRealm_QueryVariableResponse_TO_RoboRealm_Proxy_QueryVariableResponse);
            AddProxyTransform(typeof(RoboRealm.Proxy.QueryVariablesRequest), Transform_RoboRealm_Proxy_QueryVariablesRequest_TO_RoboRealm_QueryVariablesRequest);
            AddSourceTransform(typeof(RoboRealm.QueryVariablesRequest), Transform_RoboRealm_QueryVariablesRequest_TO_RoboRealm_Proxy_QueryVariablesRequest);
            AddProxyTransform(typeof(RoboRealm.Proxy.QueryVariablesResponse), Transform_RoboRealm_Proxy_QueryVariablesResponse_TO_RoboRealm_QueryVariablesResponse);
            AddSourceTransform(typeof(RoboRealm.QueryVariablesResponse), Transform_RoboRealm_QueryVariablesResponse_TO_RoboRealm_Proxy_QueryVariablesResponse);
            AddProxyTransform(typeof(RoboRealm.Proxy.UpdateFrameRequest), Transform_RoboRealm_Proxy_UpdateFrameRequest_TO_RoboRealm_UpdateFrameRequest);
            AddSourceTransform(typeof(RoboRealm.UpdateFrameRequest), Transform_RoboRealm_UpdateFrameRequest_TO_RoboRealm_Proxy_UpdateFrameRequest);
            AddProxyTransform(typeof(RoboRealm.Proxy.SetFrameRequest), Transform_RoboRealm_Proxy_SetFrameRequest_TO_RoboRealm_SetFrameRequest);
            AddSourceTransform(typeof(RoboRealm.SetFrameRequest), Transform_RoboRealm_SetFrameRequest_TO_RoboRealm_Proxy_SetFrameRequest);
            AddProxyTransform(typeof(RoboRealm.Proxy.SetVariableRequest), Transform_RoboRealm_Proxy_SetVariableRequest_TO_RoboRealm_SetVariableRequest);
            AddSourceTransform(typeof(RoboRealm.SetVariableRequest), Transform_RoboRealm_SetVariableRequest_TO_RoboRealm_Proxy_SetVariableRequest);
            AddProxyTransform(typeof(RoboRealm.Proxy.LoadProgramRequest), Transform_RoboRealm_Proxy_LoadProgramRequest_TO_RoboRealm_LoadProgramRequest);
            AddSourceTransform(typeof(RoboRealm.LoadProgramRequest), Transform_RoboRealm_LoadProgramRequest_TO_RoboRealm_Proxy_LoadProgramRequest);
            AddProxyTransform(typeof(RoboRealm.Proxy.LoadProgramResponse), Transform_RoboRealm_Proxy_LoadProgramResponse_TO_RoboRealm_LoadProgramResponse);
            AddSourceTransform(typeof(RoboRealm.LoadProgramResponse), Transform_RoboRealm_LoadProgramResponse_TO_RoboRealm_Proxy_LoadProgramResponse);
            AddProxyTransform(typeof(RoboRealm.Proxy.ExecuteProgramRequest), Transform_RoboRealm_Proxy_ExecuteProgramRequest_TO_RoboRealm_ExecuteProgramRequest);
            AddSourceTransform(typeof(RoboRealm.ExecuteProgramRequest), Transform_RoboRealm_ExecuteProgramRequest_TO_RoboRealm_Proxy_ExecuteProgramRequest);
            AddProxyTransform(typeof(RoboRealm.Proxy.ExecuteProgramResponse), Transform_RoboRealm_Proxy_ExecuteProgramResponse_TO_RoboRealm_ExecuteProgramResponse);
            AddSourceTransform(typeof(RoboRealm.ExecuteProgramResponse), Transform_RoboRealm_ExecuteProgramResponse_TO_RoboRealm_Proxy_ExecuteProgramResponse);
            AddProxyTransform(typeof(RoboRealm.Proxy.SetCaptureRequest), Transform_RoboRealm_Proxy_SetCaptureRequest_TO_RoboRealm_SetCaptureRequest);
            AddSourceTransform(typeof(RoboRealm.SetCaptureRequest), Transform_RoboRealm_SetCaptureRequest_TO_RoboRealm_Proxy_SetCaptureRequest);
            AddProxyTransform(typeof(RoboRealm.Proxy.VariableInstance), Transform_RoboRealm_Proxy_VariableInstance_TO_RoboRealm_VariableInstance);
            AddSourceTransform(typeof(RoboRealm.VariableInstance), Transform_RoboRealm_VariableInstance_TO_RoboRealm_Proxy_VariableInstance);
            AddProxyTransform(typeof(RoboRealm.Proxy.SetFrameResponse), Transform_RoboRealm_Proxy_SetFrameResponse_TO_RoboRealm_SetFrameResponse);
            AddSourceTransform(typeof(RoboRealm.SetFrameResponse), Transform_RoboRealm_SetFrameResponse_TO_RoboRealm_Proxy_SetFrameResponse);
            AddProxyTransform(typeof(RoboRealm.Proxy.SetCaptureResponse), Transform_RoboRealm_Proxy_SetCaptureResponse_TO_RoboRealm_SetCaptureResponse);
            AddSourceTransform(typeof(RoboRealm.SetCaptureResponse), Transform_RoboRealm_SetCaptureResponse_TO_RoboRealm_Proxy_SetCaptureResponse);
        }
    }
}

