//------------------------------------------------------------------------------
// InterfaceTypes.cs
//
//     This code was generated by the DssNewService tool.
//
//------------------------------------------------------------------------------
using Microsoft.Ccr.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using System;
using System.Collections.Generic;
using W3C.Soap;
using System.Net;
using Microsoft.Dss.Core.DsspHttp;
using System.Drawing;
using W3C.Soap;
using Microsoft.Dss.Core.DsspHttp;
using System.ComponentModel;

namespace RoboRealm
{
    /// <summary>
    /// Interface Contract
    /// </summary>
    public sealed class Contract
    {
        /// The Unique Contract Identifier for the Interface service
        public const String Identifier = "http://www.roborealm.com/2007/05/interface.html";
    }

    /// <summary>
    /// Interface State
    /// </summary>
    [DataContract()]
    public class InterfaceState
    {
        private Bitmap _image = new Bitmap(100, 100);
        private String _xmlString;
        private List<VariableInstance> _variables = new List<VariableInstance>();

        public Bitmap Image
        {
            get { return _image; }
            set { _image = value; }
        }

        [DataMember]
        public Size Size
        {
            get
            {
                if (_image != null)
                {
                    return _image.Size;
                }
                return Size.Empty;
            }
            set { return; }
        }

        [DataMember]
        public List<VariableInstance> Variables
        {
            get { return _variables; }
            set { _variables = value; }
        }

        [DataMember]
        public String XmlString
        {
            get { return _xmlString; }
            set { _xmlString = value; }
        }

        private DateTime _timeStamp;

        [DataMember]
        public DateTime TimeStamp
        {
            get { return _timeStamp; }
            set { _timeStamp = value; }
        }
    }

    [DataContract]
    public class VariableInstance
    {
        public VariableInstance()
        {
        }

        public VariableInstance(string n, string v)
        {
            _name = n;
            _value = v;
        }

        private string _name;
        [DataMember]
        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }

        private string _value;
        [DataMember]
        public string Value
        {
            get { return _value; }
            set { _value = value; }
        }
    }

    [DataContract]
    public class QueryVariableRequest
    {
        private string _name;

        [DataMember]
        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }
    }

    [DataContract]
    public class QueryVariablesRequest
    {
        [DataMember]
        public List<String> _names = new List<String>();

        public void Add(string value)
        {
            _names.Add(value);
        }

        public string ItemAt(int i)
        {
            return _names[i];
        }

        public int Count()
        {
            return _names.Count;
        }
    }

    [DataContract]
    public class QueryVariablesResponse
    {
        [DataMember]
        public List<String> _values = new List<String>();
    }

    [DataContract]
    public class QueryVariableResponse
    {
        private string _name;

        [DataMember]
        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }

        private string _value;
        [DataMember]
        public string Value
        {
            get { return _value; }
            set { _value = value; }
        }
    }

    [DataContract]
    public class QueryFrameRequest
    {
        [DataMember]
        public Guid Format;
        [DataMember]
        public Size Size;
    }

    [DataContract]
    public class QueryFrameResponse
    {
        [DataMember]
        public Guid Format;
        [DataMember]
        public Size Size;
        [DataMember]
        public byte[] Frame;
        [DataMember]
        public DateTime TimeStamp;
    }

    [DataContract]
    public class SetFrameRequest
    {
        [DataMember]
        public Guid Format;
        [DataMember]
        public Size Size;
        [DataMember]
        public byte[] pixels;
        [DataMember]
        public DateTime TimeStamp;
    }

    [DataContract]
    public class SetFrameResponse
    {
        [DataMember]
        public Guid Format;
        [DataMember]
        public Size Size;
        [DataMember]
        public byte[] Frame;
        [DataMember]
        public DateTime TimeStamp;
    }

    [DataContract]
    public class SetCaptureRequest
    {
        [DataMember]
        public bool captureVariable;
        [DataMember]
        public bool captureImage;
    }

    [DataContract]
    public class SetCaptureResponse
    {
        [DataMember]
        public bool captureVariable;
        [DataMember]
        public bool captureImage;
    }

    [DataContract]
    public class UpdateFrameRequest
    {
        [DataMember]
        public DateTime TimeStamp;
    }

    [DataContract]
    public class SetVariableRequest
    {
        private VariableInstance _variable = new VariableInstance();

        public SetVariableRequest() { }

        [DataMember(IsRequired = true)]
        public VariableInstance Variable
        {
            get { return _variable; }
            set { _variable = value; }
        }
    }

    [DataContract]
    public class LoadProgramRequest
    {
        private String _filename;

        public LoadProgramRequest()
        {
        }

        public LoadProgramRequest(string f)
        {
            _filename = f;
        }

        [DataMember(IsRequired = true)]
        public String Filename
        {
            get { return _filename; }
            set { _filename = value; }
        }
    }

    [DataContract]
    public class LoadProgramResponse
    {
        private String _error;
        [DataMember(IsRequired = true)]
        public String Error
        {
            get { return _error; }
            set { _error = value; }
        }
    }

    [DataContract]
    public class ExecuteProgramRequest
    {
        private String _source;

        public ExecuteProgramRequest()
        {
        }

        public ExecuteProgramRequest(string s)
        {
            _source = s;
        }

        [DataMember(IsRequired = true)]
        public String Source
        {
            get { return _source; }
            set { _source = value; }
        }
    }

    [DataContract]
    public class ExecuteProgramResponse
    {
        private String _error;
        [DataMember(IsRequired = true)]
        public String Error
        {
            get { return _error; }
            set { _error = value; }
        }
    }

    [DisplayName("SetVariable")]
    [Description("Changes a RoboRealm Variable.")]
    public class SetVariable : Update<SetVariableRequest, PortSet<DefaultUpdateResponseType, Fault>>
    {
    }

    [DisplayName("SetFrame")]
    [Description("Changes a RoboRealm Variable.")]
    public class SetFrame : Update<SetFrameRequest, PortSet<DefaultUpdateResponseType, Fault>>
    {
    }

    [DisplayName("SetCapture")]
    [Description("Sets if the interface needs to capture images and/or variables.")]
    public class SetCapture : Update<SetCaptureRequest, PortSet<DefaultUpdateResponseType, Fault>>
    {
    }

    /// <summary>
    /// Interface Operations
    /// </summary>
    public class InterfaceOperations : PortSet<DsspDefaultLookup, DsspDefaultDrop, Get, HttpGet, HttpPost, HttpQuery, QueryFrame, QueryVariable, QueryVariables, UpdateFrame, Subscribe, SetFrame, SetVariable, LoadProgram, ExecuteProgram, SetCapture>
    {
    }
    /// <summary>
    /// Get
    /// </summary>
    public class Get : Get<GetRequestType, PortSet<InterfaceState, Fault>>
    {
    }

    [DisplayName("GetVariables")]
    [Description("Gets multiple variable values.")]
    public class QueryVariables : Query<QueryVariablesRequest, PortSet<QueryVariablesResponse, Fault>>
    {
    }

    [DisplayName("GetVariable")]
    [Description("Gets the most recently value of specified variable.")]
    public class QueryVariable : Query<QueryVariableRequest, PortSet<QueryVariableResponse, Fault>>
    {
    }

    [DisplayName("LoadProgram")]
    [Description("Loads a program into RoboRealm specified by the filename.")]
    public class LoadProgram : Query<LoadProgramRequest, PortSet<LoadProgramResponse, Fault>>
    {
    }

    [DisplayName("ExecuteProgram")]
    [Description("Executes a provided program in RoboRealm.")]
    public class ExecuteProgram : Query<ExecuteProgramRequest, PortSet<ExecuteProgramResponse, Fault>>
    {
    }

    [DisplayName("GetFrame")]
    [Description("Gets the most recently captured frame.")]
    public class QueryFrame : Query<QueryFrameRequest, PortSet<QueryFrameResponse, Fault>>
    {
    }

    [DisplayName("NewFrame")]
    [Description("Indicates when a new frame has been captured.")]
    public class UpdateFrame : Update<UpdateFrameRequest, PortSet<DefaultUpdateResponseType, Fault>>
    {
    }

    public class Subscribe : Subscribe<SubscribeRequestType, PortSet<SubscribeResponseType, Fault>>
    {
    }
}
